#
# spec file for package firefox-esr
#
# Copyright (c) 2014 SUSE LINUX Products GmbH, Nuernberg, Germany.
#               2006-2014 Wolfgang Rosenauer
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via http://bugs.opensuse.org/
#


%define major 31
%define mainver %major.3.0
%define update_channel esr31

%if %suse_version > 1210
%if %suse_version > 1310
%define gstreamer_ver 1.0
%define gstreamer 1
%else
%define gstreamer_ver 0.10
%endif
%endif

Name:           firefox-esr
BuildRequires:  Mesa-devel
BuildRequires:  autoconf213
BuildRequires:  dbus-1-glib-devel
BuildRequires:  fdupes
BuildRequires:  gcc-c++
BuildRequires:  libcurl-devel
BuildRequires:  libgnomeui-devel
BuildRequires:  libidl-devel
BuildRequires:  libnotify-devel
%if %suse_version > 1140
BuildRequires:  makeinfo
%endif
BuildRequires:  python-devel
BuildRequires:  startup-notification-devel
BuildRequires:  unzip
BuildRequires:  update-desktop-files
BuildRequires:  xorg-x11-libXt-devel
BuildRequires:  xz
BuildRequires:  yasm
BuildRequires:  zip
%if %suse_version > 1110
BuildRequires:  libiw-devel
BuildRequires:  libproxy-devel
%else
BuildRequires:  wireless-tools
%endif
BuildRequires:  mozilla-nspr-devel >= 4.10.6
BuildRequires:  mozilla-nss-devel >= 3.16.5
BuildRequires:  nss-shared-helper-devel
BuildRequires:  pkgconfig(libpulse)
%if %suse_version > 1210
BuildRequires:  pkgconfig(gstreamer-%gstreamer_ver)
BuildRequires:  pkgconfig(gstreamer-app-%gstreamer_ver)
BuildRequires:  pkgconfig(gstreamer-plugins-base-%gstreamer_ver)
%if 0%{?gstreamer} == 1
Requires:       libgstreamer-1_0-0
Recommends:     gstreamer-fluendo-mp3
Recommends:     gstreamer-plugins-libav
%else
Requires:       libgstreamer-0_10-0
Recommends:     gstreamer-0_10-fluendo-mp3
Recommends:     gstreamer-0_10-plugins-ffmpeg
%endif
%endif
Version:        %{mainver}
Release:        2.2
%define         releasedate 2014112600
Provides:       firefox-esr = %{mainver}
Provides:       firefox-esr = %{version}-%{release}
Provides:       web_browser
Provides:       browser(npapi)
# this is needed to match this package with the kde4 helper package without the main package
# having a hard requirement on the kde4 package
%define kde_helper_version 6
Provides:       mozilla-kde4-version = %{kde_helper_version}
Conflicts:      firefox
Summary:        Mozilla Firefox Web Browser
License:        MPL-2.0
Group:          Productivity/Networking/Web/Browsers
Url:            http://www.mozilla.org/
Source:         firefox-%{version}-source.tar.xz
Source1:        MozillaFirefox.desktop
Source2:        MozillaFirefox-rpmlintrc
Source3:        mozilla.sh.in
Source4:        find-external-requires.sh
Source5:        source-stamp.txt
Source6:        kde.js
Source7:        l10n-%{version}.tar.xz
Source8:        firefox-mimeinfo.xml
Source9:        firefox.js
Source10:       compare-locales.tar.xz
Source11:       firefox.1
Source12:       mozilla-get-app-id
Source13:       spellcheck.js
Source14:       create-tar.sh
# Gecko/Toolkit
Patch1:         toolkit-download-folder.patch
Patch2:         mozilla-nongnome-proxies.patch
Patch3:         mozilla-prefer_plugin_pref.patch
Patch4:         mozilla-shared-nss-db.patch
Patch5:         mozilla-kde.patch
Patch6:         mozilla-preferences.patch
Patch7:         mozilla-language.patch
Patch8:         mozilla-ntlm-full-path.patch
Patch9:         mozilla-repo.patch
Patch10:        mozilla-sle11.patch
Patch11:        mozilla-icu-strncat.patch
Patch12:        mozilla-arm-disable-edsp.patch
Patch13:        mozilla-ppc.patch
Patch14:        mozilla-libproxy-compat.patch
Patch15:        mozilla-nullptr-gcc45.patch
# Gecko/Toolkit AArch64 Porting
Patch30:        mozilla-aarch64-bmo-810631.patch

# Firefox/browser
Patch101:       firefox-kde.patch
Patch102:       firefox-kde-114.patch
Patch103:       firefox-no-default-ualocale.patch
Patch104:       firefox-multilocale-chrome.patch
Patch105:       firefox-branded-icons.patch
BuildRoot:      %{_tmppath}/%{name}-%{version}-build
Requires(post):   coreutils shared-mime-info desktop-file-utils
Requires(postun): shared-mime-info desktop-file-utils
Requires:       %{name}-branding > 20.0
Requires:       mozilla-nspr >= %(rpm -q --queryformat '%{VERSION}' mozilla-nspr)
Requires:       mozilla-nss >= %(rpm -q --queryformat '%{VERSION}' mozilla-nss)
Recommends:     libcanberra0
Recommends:     libpulse0
# libproxy's mozjs pacrunner crashes FF (bnc#759123)
%if %suse_version < 1220
Obsoletes:      libproxy1-pacrunner-mozjs <= 0.4.7
%endif
%define firefox_appid \{ec8030f7-c20a-464f-9b0e-13a3a9e97384\}
%define _use_internal_dependency_generator 0
%define __find_requires sh %{SOURCE4}
%global provfind sh -c "grep -v '.so' | %__find_provides"
%global __find_provides %provfind
%define progname firefox
%define progdir %{_prefix}/%_lib/%{progname}
%define gnome_dir     %{_prefix}
%if %suse_version > 1130
%define desktop_file_name firefox
%else
%define desktop_file_name %{name}
%endif
### build options
# Set up Google API keys, see http://www.chromium.org/developers/how-tos/api-keys
# Note: these are for the openSUSE Firefox builds ONLY. For your own distribution,
# please get your own set of keys.
%define _google_api_key AIzaSyD1hTe85_a14kr1Ks8T3Ce75rvbR1_Dx7Q
%define branding 1
%define localize 1
%ifarch aarch64 ppc ppc64 ppc64le s390 s390x ia64 %arm
%define crashreporter 0
%else
%define crashreporter 1
%endif
### build options end

%description
Mozilla Firefox is a standalone web browser, designed for standards
compliance and performance.  Its functionality can be enhanced via a
plethora of extensions.

%package devel
Summary:        Devel package for Firefox
Group:          Development/Tools/Other
Provides:       firefox-devel = %{version}-%{release}
Requires:       %{name} = %{version}
Requires:       perl(Archive::Zip)
Requires:       perl(XML::Simple)

%description devel
Development files for Firefox to make packaging of addons easier.

%if %localize
%package translations-common
Summary:        Common translations for Firefox
Group:          System/Localization
Provides:       locale(%{name}:ar;ca;cs;da;de;en_GB;el;es_AR;es_CL;es_ES;fi;fr;hu;it;ja;ko;nb_NO;nl;pl;pt_BR;pt_PT;ru;sv_SE;zh_CN;zh_TW)
Requires:       %{name} = %{version}
Obsoletes:      %{name}-translations < %{version}-%{release}

%description translations-common
This package contains several common languages for the user interface
of Firefox.

%package translations-other
Summary:        Extra translations for Firefox
Group:          System/Localization
Provides:       locale(%{name}:ach;af;ak;as;ast;be;bg;bn_BD;bn_IN;br;bs;csb;cy;en_ZA;eo;es_MX;et;eu;fa;ff;fy_NL;ga_IE;gd;gl;gu_IN;he;hi_IN;hr;hy_AM;id;is;kk;km;kn;ku;lg;lij;lt;lv;mai;mk;ml;mr;nn_NO;nso;or;pa_IN;rm;ro;si;sk;sl;son;sq;sr;ta;ta_LK;te;th;tr;uk;vi;zu)
Requires:       %{name} = %{version}
Obsoletes:      %{name}-translations < %{version}-%{release}

%description translations-other
This package contains rarely used languages for the user interface
of Firefox.
%endif

%package branding-upstream
Summary:        Upstream branding for Firefox
Group:          Productivity/Networking/Web/Browsers
Provides:       %{name}-branding = %{version}
Conflicts:      otherproviders(MozillaFirefox-branding)
Supplements:    packageand(%{name}:branding-upstream)
#BRAND: Provide three files -
#BRAND: /usr/lib/firefox/browserconfig.properties that contains the
#BRAND: default homepage and some other default configuration options
#BRAND: /usr/lib/firefox/defaults/profile/bookmarks.html that contains
#BRAND: the list of default bookmarks
#BRAND: It's also possible to create a file
#BRAND: /usr/lib/firefox/defaults/preferences/firefox-$vendor.js to set
#BRAND: custom preference overrides.
#BRAND: It's also possible to drop files in /usr/lib/firefox/searchplugins

%description branding-upstream
This package provides upstream look and feel for Firefox.


%if %crashreporter

%package buildsymbols
Summary:        Breakpad buildsymbols for %{name}
Group:          Development/Debug

%description buildsymbols
This subpackage contains the Breakpad created and compatible debugging
symbols meant for upload to Mozilla's crash collector database.
%endif

%prep
%if %localize
%setup -q -n mozilla -b 7 -b 10
%else
%setup -q -n mozilla
%endif
cd $RPM_BUILD_DIR/mozilla
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1
%patch9 -p1
%if %suse_version < 1120
%patch10 -p1
%endif
%patch11 -p1
%patch12 -p1
%patch13 -p1
%patch14 -p1
%patch15 -p1
%patch30 -p1

# Firefox
%patch101 -p1
%if %suse_version >= 1140
%patch102 -p1
%endif
%patch103 -p1
%patch104 -p1
%patch105 -p1

%build
# no need to add build time to binaries
modified="$(sed -n '/^----/n;s/ - .*$//;p;q' "%{_sourcedir}/%{name}.changes")"
DATE="\"$(date -d "${modified}" "+%%b %%e %%Y")\""
TIME="\"$(date -d "${modified}" "+%%R")\""
find . -regex ".*\.c\|.*\.cpp\|.*\.h" -exec sed -i "s/__DATE__/${DATE}/g;s/__TIME__/${TIME}/g" {} +
#
kdehelperversion=$(cat toolkit/xre/nsKDEUtils.cpp | grep '#define KMOZILLAHELPER_VERSION' | cut -d ' ' -f 3)
if test "$kdehelperversion" != %{kde_helper_version}; then
  echo fix kde helper version in the .spec file
  exit 1
fi
source %{SOURCE5}
export MOZ_SOURCE_STAMP=$REV
export SOURCE_REPO=$REPO
export source_repo=$REPO
export MOZ_SOURCE_REPO=$REPO
export MOZ_BUILD_DATE=%{releasedate}
export MOZILLA_OFFICIAL=1
export BUILD_OFFICIAL=1
export MOZ_TELEMETRY_REPORTING=1
export MOZ_GOOGLE_API_KEY=%{_google_api_key}
export CFLAGS="$RPM_OPT_FLAGS -Os -fno-strict-aliasing"
%ifarch %arm
export CFLAGS="${CFLAGS/-g / }"
%endif
%ifarch ppc64 ppc64le
export CFLAGS="$CFLAGS -mminimal-toc"
%endif
export CXXFLAGS="$CFLAGS"
export MOZCONFIG=$RPM_BUILD_DIR/mozconfig
cat << EOF > $MOZCONFIG
mk_add_options MOZILLA_OFFICIAL=1
mk_add_options BUILD_OFFICIAL=1
mk_add_options MOZ_MAKE_FLAGS=%{?jobs:-j%jobs}
mk_add_options MOZ_OBJDIR=@TOPSRCDIR@/../obj
. \$topsrcdir/browser/config/mozconfig
ac_add_options --prefix=%{_prefix}
ac_add_options --libdir=%{_libdir}
ac_add_options --sysconfdir=%{_sysconfdir}
ac_add_options --mandir=%{_mandir}
ac_add_options --includedir=%{_includedir}
ac_add_options --with-system-nspr
ac_add_options --with-system-nss
%if %{localize}
ac_add_options --with-l10n-base=$RPM_BUILD_DIR/l10n
%endif
#ac_add_options --with-system-jpeg    # libjpeg-turbo is used internally
#ac_add_options --with-system-png     # doesn't work because of missing APNG support
ac_add_options --with-system-zlib
ac_add_options --disable-installer
ac_add_options --disable-updater
ac_add_options --disable-tests
ac_add_options --disable-debug
ac_add_options --enable-startup-notification
#ac_add_options --enable-chrome-format=jar
ac_add_options --enable-update-channel=%{update_channel}
%if 0%{?gstreamer} == 1
ac_add_options --enable-gstreamer=1.0
%endif
%if %suse_version > 1130
ac_add_options --disable-gnomevfs
ac_add_options --enable-gio
%endif
%if %suse_version < 1220
ac_add_options --disable-gstreamer
%endif
%if %branding
ac_add_options --enable-official-branding
%endif
%if %suse_version > 1110
ac_add_options --enable-libproxy
%endif
%if ! %crashreporter
ac_add_options --disable-crashreporter
%endif
# Disable neon for arm as it does not build correctly
%ifarch %arm
ac_add_options --disable-neon
%endif
%ifnarch %ix86 x86_64
ac_add_options --disable-webrtc
%endif
# try to use OpenGL-ES on ARM
%ifarch %arm
ac_add_options --with-gl-provider=EGL
%endif
EOF
make -f client.mk build

%install
cd $RPM_BUILD_DIR/obj
source %{SOURCE5}
export MOZ_SOURCE_STAMP=$REV
export MOZ_SOURCE_REPO=$REPO
# need to remove default en-US firefox-l10n.js before it gets
# populated into browser's omni.ja; it only contains general.useragent.locale
# which should be loaded from each language pack (set in firefox.js)
rm dist/bin/browser/defaults/preferences/firefox-l10n.js
make -C browser/installer STRIP=/bin/true MOZ_PKG_FATAL_WARNINGS=0
#DEBUG (break the build if searchplugins are missing / temporary)
grep amazondotcom dist/firefox/browser/omni.ja
# copy tree into RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT%{progdir}
cp -rf $RPM_BUILD_DIR/obj/dist/firefox/* $RPM_BUILD_ROOT%{progdir}
mkdir -p $RPM_BUILD_ROOT%{progdir}/distribution/extensions
mkdir -p $RPM_BUILD_ROOT%{progdir}/browser/searchplugins
mkdir -p $RPM_BUILD_ROOT%{progdir}/browser/defaults/preferences/
# install gre prefs
install -m 644 %{SOURCE13} %{buildroot}%{progdir}/defaults/pref/
# install browser prefs
install -m 644 %{SOURCE6} $RPM_BUILD_ROOT%{progdir}/browser/defaults/preferences/kde.js
install -m 644 %{SOURCE9} $RPM_BUILD_ROOT%{progdir}/browser/defaults/preferences/firefox.js
# install additional locales
%if %localize
rm -f %{_tmppath}/translations.*
touch %{_tmppath}/translations.{common,other}
for locale in $(awk '{ print $1; }' ../mozilla/browser/locales/shipped-locales); do
  case $locale in
   ja-JP-mac|en-US)
	;;
   *)
   	pushd $RPM_BUILD_DIR/compare-locales
	PYTHONPATH=lib \
	  scripts/compare-locales -m ../l10n-merged/$locale \
	  ../mozilla/browser/locales/l10n.ini ../l10n $locale
	popd
	LOCALE_MERGEDIR=$RPM_BUILD_DIR/l10n-merged/$locale \
  	make -C browser/locales langpack-$locale
	cp -rL dist/xpi-stage/locale-$locale \
	       $RPM_BUILD_ROOT%{progdir}/browser/extensions/langpack-$locale@firefox.mozilla.org
	# remove prefs, profile defaults, and hyphenation from langpack
	rm -rf $RPM_BUILD_ROOT%{progdir}/browser/extensions/langpack-$locale@firefox.mozilla.org/defaults
	rm -rf $RPM_BUILD_ROOT%{progdir}/browser/extensions/langpack-$locale@firefox.mozilla.org/hyphenation
	# check against the fixed common list and sort into the right filelist
	_matched=0
	for _match in ar ca cs da de en-GB el es-AR es-CL es-ES fi fr hu it ja ko nb-NO nl pl pt-BR pt-PT ru sv-SE zh-CN zh-TW; do
	  [ "$_match" = "$locale" ] && _matched=1
	done
	[ $_matched -eq 1 ] && _l10ntarget=common || _l10ntarget=other
  	echo %{progdir}/browser/extensions/langpack-$locale@firefox.mozilla.org \
	  >> %{_tmppath}/translations.$_l10ntarget
  esac
done
%endif
# remove some executable permissions
find $RPM_BUILD_ROOT%{progdir} \
     -name "*.js" -o \
     -name "*.jsm" -o \
     -name "*.rdf" -o \
     -name "*.properties" -o \
     -name "*.dtd" -o \
     -name "*.txt" -o \
     -name "*.xml" -o \
     -name "*.css" | xargs chmod a-x
# remove mkdir.done files from installed base
find $RPM_BUILD_ROOT%{progdir} -name ".mkdir.done" | xargs rm
# overwrite the mozilla start-script and link it to /usr/bin
mkdir --parents $RPM_BUILD_ROOT/usr/bin
sed "s:%%PREFIX:%{_prefix}:g
s:%%PROGDIR:%{progdir}:g
s:%%APPNAME:firefox:g
s:%%PROFILE:.mozilla/firefox:g" \
  %{SOURCE3} > $RPM_BUILD_ROOT%{progdir}/%{progname}.sh
chmod 755 $RPM_BUILD_ROOT%{progdir}/%{progname}.sh
ln -sf ../..%{progdir}/%{progname}.sh $RPM_BUILD_ROOT%{_bindir}/%{progname}
# desktop definition
mkdir -p $RPM_BUILD_ROOT%{_datadir}/applications
install -m 644 %{SOURCE1} \
   $RPM_BUILD_ROOT%{_datadir}/applications/%{desktop_file_name}.desktop
# additional mime-types
mkdir -p $RPM_BUILD_ROOT%{_datadir}/mime/packages
cp %{SOURCE8} $RPM_BUILD_ROOT%{_datadir}/mime/packages/%{progname}.xml
# install man-page
mkdir -p $RPM_BUILD_ROOT%{_mandir}/man1/
cp %{SOURCE11} $RPM_BUILD_ROOT%{_mandir}/man1/%{progname}.1
##########
# ADDONS
#
mkdir -p $RPM_BUILD_ROOT%{_datadir}/mozilla/extensions/%{firefox_appid}
mkdir -p $RPM_BUILD_ROOT%{_libdir}/mozilla/extensions/%{firefox_appid}
mkdir -p $RPM_BUILD_ROOT/usr/share/pixmaps/
ln -sf %{progdir}/browser/icons/mozicon128.png $RPM_BUILD_ROOT/usr/share/pixmaps/%{progname}.png
ln -sf %{progdir}/browser/icons/mozicon128.png $RPM_BUILD_ROOT/usr/share/pixmaps/%{progname}-gnome.png
%if %branding
for size in 16 22 24 32 48 256; do
%else
for size in 16 32 48; do
%endif
  mkdir -p $RPM_BUILD_ROOT%{gnome_dir}/share/icons/hicolor/${size}x${size}/apps/
  ln -sf %{progdir}/browser/chrome/icons/default/default$size.png \
         $RPM_BUILD_ROOT%{gnome_dir}/share/icons/hicolor/${size}x${size}/apps/%{progname}.png
done
%suse_update_desktop_file %{desktop_file_name} Network WebBrowser GTK
# excludes
rm -f $RPM_BUILD_ROOT%{progdir}/updater.ini
rm -f $RPM_BUILD_ROOT%{progdir}/removed-files
rm -f $RPM_BUILD_ROOT%{progdir}/README.txt
rm -f $RPM_BUILD_ROOT%{progdir}/old-homepage-default.properties
rm -f $RPM_BUILD_ROOT%{progdir}/run-mozilla.sh
rm -f $RPM_BUILD_ROOT%{progdir}/LICENSE
rm -f $RPM_BUILD_ROOT%{progdir}/precomplete
rm -f $RPM_BUILD_ROOT%{progdir}/dictionaries/en-US*
rm -f $RPM_BUILD_ROOT%{progdir}/update-settings.ini
# devel
mkdir -p %{buildroot}%{_bindir}
install -m 755 %SOURCE12 %{buildroot}%{_bindir}
# inspired by mandriva
mkdir -p %{buildroot}/etc/rpm
cat <<'FIN' >%{buildroot}/etc/rpm/macros.%{progname}
# Macros from %{name} package
%%firefox_major              %{major}
%%firefox_version            %{version}
%%firefox_mainver            %{mainver}
%%firefox_mozillapath        %%{_libdir}/%{progname}
%%firefox_pluginsdir         %%{_libdir}/browser-plugins
%%firefox_appid              \{ec8030f7-c20a-464f-9b0e-13a3a9e97384\}
%%firefox_extdir             %%(if [ "%%_target_cpu" = "noarch" ]; then echo %%{_datadir}/mozilla/extensions/%%{firefox_appid}; else echo %%{_libdir}/mozilla/extensions/%%{firefox_appid}; fi)

%%firefox_ext_install() \
   extdir="%%{buildroot}%%{firefox_extdir}/`mozilla-get-app-id '%%1'`" \
   mkdir -p "$extdir" \
   %%{__unzip} -q -d "$extdir" "%%1" \
   %%{nil}
FIN
# just dumping an xpi file there doesn't work...
#%%firefox_ext_install() \
#       extdir="%%{buildroot}%%{firefox_extdir}" \
#       mkdir -p "$extdir" \
#       cp "%%1" "$extdir" \
#       %%{nil}
# fdupes
%fdupes $RPM_BUILD_ROOT%{progdir}
%fdupes $RPM_BUILD_ROOT%{_datadir}
# create breakpad debugsymbols
%if %crashreporter
SYMBOLS_NAME="firefox-%{version}-%{release}.%{_arch}-%{suse_version}-symbols"
make buildsymbols \
  SYMBOL_INDEX_NAME="$SYMBOLS_NAME.txt" \
  SYMBOL_FULL_ARCHIVE_BASENAME="$SYMBOLS_NAME-full" \
  SYMBOL_ARCHIVE_BASENAME="$SYMBOLS_NAME"
if [ -e dist/*symbols.zip ]; then
  mkdir -p $RPM_BUILD_ROOT%{_datadir}/mozilla/
  cp dist/*symbols.zip $RPM_BUILD_ROOT%{_datadir}/mozilla/
fi
%endif

%clean
rm -rf $RPM_BUILD_ROOT
%if %localize
rm -rf %{_tmppath}/translations.*
%endif

%post
# update mime and desktop database
%if %suse_version > 1130
%mime_database_post
%desktop_database_post
%icon_theme_cache_post
%else
if [ -f usr/bin/update-mime-database ] ; then
  usr/bin/update-mime-database %{_datadir}/mime > /dev/null || :
fi
if [ -f usr/bin/update-desktop-database ] ; then
  usr/bin/update-desktop-database > /dev/null || :
fi
%endif
exit 0

%postun
%if %suse_version > 1130
%icon_theme_cache_postun
%desktop_database_postun
%mime_database_postun
%else
if [ -f usr/bin/update-mime-database ] ; then
  usr/bin/update-mime-database %{_datadir}/mime > /dev/null || :
fi
if [ -f usr/bin/update-desktop-database ] ; then
  usr/bin/update-desktop-database > /dev/null || :
fi
%endif
exit 0

%files
%defattr(-,root,root)
%dir %{progdir}
%dir %{progdir}/browser/
%dir %{progdir}/browser/chrome/
%dir %{progdir}/browser/extensions/
%{progdir}/browser/components/
%{progdir}/browser/defaults
%{progdir}/browser/icons/
%{progdir}/browser/chrome/icons
%{progdir}/browser/extensions/{972ce4c6-7e08-4474-a285-3208198ce6fd}
%{progdir}/browser/searchplugins/
%{progdir}/browser/blocklist.xml
%{progdir}/browser/chrome.manifest
%{progdir}/browser/omni.ja
%dir %{progdir}/distribution/
%{progdir}/distribution/extensions/
%{progdir}/components/
%{progdir}/defaults/
%{progdir}/dictionaries/
%{progdir}/webapprt/
%attr(755,root,root) %{progdir}/%{progname}.sh
%{progdir}/firefox
%{progdir}/firefox-bin
%{progdir}/application.ini
%{progdir}/dependentlibs.list
%{progdir}/*.so
%{progdir}/mozilla-xremote-client
%{progdir}/omni.ja
%{progdir}/platform.ini
%{progdir}/plugin-container
%{progdir}/webapprt-stub
%{progdir}/chrome.manifest
%if %crashreporter
%{progdir}/crashreporter
%{progdir}/crashreporter.ini
%{progdir}/Throbber-small.gif
%{progdir}/browser/crashreporter-override.ini
%endif
%{_datadir}/applications/%{desktop_file_name}.desktop
%{_datadir}/mime/packages/%{progname}.xml
%{_datadir}/pixmaps/firefox*
%dir %{_datadir}/mozilla
%dir %{_datadir}/mozilla/extensions
%dir %{_datadir}/mozilla/extensions/%{firefox_appid}
%dir %{_libdir}/mozilla
%dir %{_libdir}/mozilla/extensions
%dir %{_libdir}/mozilla/extensions/%{firefox_appid}
%{gnome_dir}/share/icons/hicolor/
%{_bindir}/%{progname}
%doc %{_mandir}/man1/%{progname}.1.gz

%files devel
%defattr(-,root,root)
%{_bindir}/mozilla-get-app-id
%config /etc/rpm/macros.%{progname}

%if %localize

%files translations-common -f %{_tmppath}/translations.common
%defattr(-,root,root)
%dir %{progdir}
%dir %{progdir}/browser/extensions/

%files translations-other -f %{_tmppath}/translations.other
%defattr(-,root,root)
%dir %{progdir}
%dir %{progdir}/browser/extensions/
%endif

# this package does not need to provide files but is needed to fulfill
# requirements if no other branding package is to be installed

%files branding-upstream
%defattr(-,root,root)
%dir %{progdir}

%if %crashreporter

%files buildsymbols
%defattr(-,root,root)
%{_datadir}/mozilla/*.zip
%endif

%changelog
* Sun Nov 30 2014 wr@rosenauer.org
- update to Firefox 31.3.0esr (bnc#908009)
  * MFSA 2014-83/CVE-2014-1587
    Miscellaneous memory safety hazards
  * MFSA 2014-85/CVE-2014-1590 (bmo#1087633)
    XMLHttpRequest crashes with some input streams
  * MFSA 2014-87/CVE-2014-1592 (bmo#1088635)
    Use-after-free during HTML5 parsing
  * MFSA 2014-88/CVE-2014-1593 (bmo#1085175)
    Buffer overflow while parsing media content
  * MFSA 2014-89/CVE-2014-1594 (bmo#1074280)
    Bad casting from the BasicThebesLayer to BasicContainerLayer
* Sun Nov  2 2014 wr@rosenauer.org
- fix typo in GStreamer Recommends
* Sat Oct 25 2014 wr@rosenauer.org
- define /usr/share/myspell as additional dictionary location
  and remove add-plugins.sh finally (bnc#900639)
* Sat Oct 11 2014 wr@rosenauer.org
- update to Firefox 31.2.0 (bnc#900941)
  * MFSA 2014-74/CVE-2014-1574
    Miscellaneous memory safety hazards
  * MFSA 2014-75/CVE-2014-1576 (bmo#1041512)
    Buffer overflow during CSS manipulation
  * MFSA 2014-76/CVE-2014-1577 (bmo#1012609)
    Web Audio memory corruption issues with custom waveforms
  * MFSA 2014-77/CVE-2014-1578 (bmo#1063327)
    Out-of-bounds write with WebM video
  * MFSA 2014-79/CVE-2014-1581 (bmo#1068218)
    Use-after-free interacting with text directionality
  * MFSA 2014-81/CVE-2014-1585/CVE-2014-1586 (bmo#1062876, bmo#1062981)
    Inconsistent video sharing within iframe
  * MFSA 2014-82/CVE-2014-1583 (bmo#1045540)
    Accessing cross-origin objects via the Alarms API
* Wed Sep 24 2014 wr@rosenauer.org
- update to Firefox 31.1.1esr
* Sat Aug 30 2014 wr@rosenauer.org
- renamed package to firefox-esr
* Fri Aug 29 2014 wr@rosenauer.org
- update to Firefox 31.1.0esr (bnc#894370)
  * MFSA 2014-67/CVE-2014-1553/CVE-2014-1562
    Miscellaneous memory safety hazards
  * MFSA 2014-68/CVE-2014-1563 (bmo#1018524)
    Use-after-free during DOM interactions with SVG
  * MFSA 2014-69/CVE-2014-1564 (bmo#1045977)
    Uninitialized memory use during GIF rendering
  * MFSA 2014-70/CVE-2014-1565 (bmo#1047831)
    Out-of-bounds read in Web Audio audio timeline
  * MFSA 2014-72/CVE-2014-1567 (bmo#1037641)
    Use-after-free setting text directionality
- changes to support compilation on 11.4
  * explicit xz BuildRequires
  * mozilla-nullptr-gcc45.patch
  * remove unresolved makeinfo BuildRequires
* Wed Aug 20 2014 behlert@suse.de
- adapted _constraints, used more than 3900MB on s390x during
  last build
* Sun Jul 20 2014 wr@rosenauer.org
- update to Firefox 31.0 (bnc#887746)
  * MFSA 2014-56/CVE-2014-1547/CVE-2014-1548
    Miscellaneous memory safety hazards
  * MFSA 2014-57/CVE-2014-1549 (bmo#1020205)
    Buffer overflow during Web Audio buffering for playback
  * MFSA 2014-58/CVE-2014-1550 (bmo#1020411)
    Use-after-free in Web Audio due to incorrect control message ordering
  * MFSA 2014-60/CVE-2014-1561 (bmo#1000514, bmo#910375)
    Toolbar dialog customization event spoofing
  * MFSA 2014-61/CVE-2014-1555 (bmo#1023121)
    Use-after-free with FireOnStateChange event
  * MFSA 2014-62/CVE-2014-1556 (bmo#1028891)
    Exploitable WebGL crash with Cesium JavaScript library
  * MFSA 2014-63/CVE-2014-1544 (bmo#963150)
    Use-after-free while when manipulating certificates in the trusted cache
    (solved with NSS 3.16.2 requirement)
  * MFSA 2014-64/CVE-2014-1557 (bmo#913805)
    Crash in Skia library when scaling high quality images
  * MFSA 2014-65/CVE-2014-1558/CVE-2014-1559/CVE-2014-1560
    (bmo#1015973, bmo#1026022, bmo#997795)
    Certificate parsing broken by non-standard character encoding
  * MFSA 2014-66/CVE-2014-1552 (bmo#985135)
    IFRAME sandbox same-origin access through redirect
- use EGL on ARM
- rebased patches
- requires NSS 3.16.2
- requires python-devel (not only python)
* Mon Jun  9 2014 wr@rosenauer.org
- update to Firefox 30.0 (bnc#881874)
  * MFSA 2014-48/CVE-2014-1533/CVE-2014-1534
    (bmo#921622, bmo#967354, bmo#969517, bmo#969549, bmo#973874,
    bmo#978652, bmo#978811, bmo#988719, bmo#990868, bmo#991981,
    bmo#992274, bmo#994907, bmo#995679, bmo#995816, bmo#995817,
    bmo#996536, bmo#996715, bmo#999651, bmo#1000598,
    bmo#1000960, bmo#1002340, bmo#1005578, bmo#1007223,
    bmo#1009952, bmo#1011007)
    Miscellaneous memory safety hazards (rv:30.0)
  * MFSA 2014-49/CVE-2014-1536/CVE-2014-1537/CVE-2014-1538
    (bmo#989994, bmo#999274, bmo#1005584)
    Use-after-free and out of bounds issues found using Address
    Sanitizer
  * MFSA 2014-50/CVE-2014-1539 (bmo#995603)
    Clickjacking through cursor invisability after Flash interaction
  * MFSA 2014-51/CVE-2014-1540 (bmo#978862)
    Use-after-free in Event Listener Manager
  * MFSA 2014-52/CVE-2014-1541 (bmo#1000185)
    Use-after-free with SMIL Animation Controller
  * MFSA 2014-53/CVE-2014-1542 (bmo#991533)
    Buffer overflow in Web Audio Speex resampler
  * MFSA 2014-54/CVE-2014-1543 (bmo#1011859)
    Buffer overflow in Gamepad API
  * MFSA 2014-55/CVE-2014-1545 (bmo#1018783)
    Out of bounds write in NSPR
- rebased patches
- removed obsolete patches
  * firefox-browser-css.patch
  * mozilla-aarch64-bmo-962488.patch
  * mozilla-aarch64-bmo-963023.patch
  * mozilla-aarch64-bmo-963024.patch
  * mozilla-aarch64-bmo-963027.patch
  * mozilla-ppc64-xpcom.patch
  * mozilla-ppc64le-javascript.patch
  * mozilla-ppc64le-libffi.patch
  * mozilla-ppc64le-mfbt.patch
  * mozilla-ppc64le-webrtc.patch
  * mozilla-ppc64le-xpcom.patch
  * mozilla-ppc64le-build.patch
- requires NSPR 4.10.6
- enabled GStreamer 1.0 usage for 13.2 and above
* Sat May 10 2014 wr@rosenauer.org
- update to Firefox 29.0.1
  * Seer disabled by default (bmo#1005958)
  * Session Restore failed with a corrupted sessionstore.js file
    (bmo#1001167)
  * pdf.js printing white page (bmo#1003707, bnc#876833)
- general.useragent.locale gets overwritten with en-US while it
  should be using the active langpack's setting
* Sat Apr 26 2014 wr@rosenauer.org
- update to Firefox 29.0 (bnc#875378)
  * MFSA 2014-34/CVE-2014-1518/CVE-2014-1519
    Miscellaneous memory safety hazards
  * MFSA 2014-36/CVE-2014-1522 (bmo#995289)
    Web Audio memory corruption issues
  * MFSA 2014-37/CVE-2014-1523 (bmo#969226)
    Out of bounds read while decoding JPG images
  * MFSA 2014-38/CVE-2014-1524 (bmo#989183)
    Buffer overflow when using non-XBL object as XBL
  * MFSA 2014-39/CVE-2014-1525 (bmo#989210)
    Use-after-free in the Text Track Manager for HTML video
  * MFSA 2014-41/CVE-2014-1528 (bmo#963962)
    Out-of-bounds write in Cairo
  * MFSA 2014-42/CVE-2014-1529 (bmo#987003)
    Privilege escalation through Web Notification API
  * MFSA 2014-43/CVE-2014-1530 (bmo#895557)
    Cross-site scripting (XSS) using history navigations
  * MFSA 2014-44/CVE-2014-1531 (bmo#987140)
    Use-after-free in imgLoader while resizing images
  * MFSA 2014-45/CVE-2014-1492 (bmo#903885)
    Incorrect IDNA domain name matching for wildcard certificates
    (fixed by NSS 3.16)
  * MFSA 2014-46/CVE-2014-1532 (bmo#966006)
    Use-after-free in nsHostResolver
  * MFSA 2014-47/CVE-2014-1526 (bmo#988106)
    Debugger can bypass XrayWrappers with JavaScript
- rebased patches
- removed obsolete patches
  * firefox-browser-css.patch
  * mozilla-aarch64-599882cfb998.diff
  * mozilla-aarch64-bmo-963028.patch
  * mozilla-aarch64-bmo-963029.patch
  * mozilla-aarch64-bmo-963030.patch
  * mozilla-aarch64-bmo-963031.patch
- requires NSS 3.16
- added mozilla-icu-strncat.patch to fix post build checks
* Mon Apr  7 2014 dmueller@suse.com
- add mozilla-aarch64-599882cfb998.patch,
    mozilla-aarch64-bmo-810631.patch,
    mozilla-aarch64-bmo-962488.patch,
    mozilla-aarch64-bmo-963030.patch,
    mozilla-aarch64-bmo-963027.patch,
    mozilla-aarch64-bmo-963028.patch,
    mozilla-aarch64-bmo-963029.patch,
    mozilla-aarch64-bmo-963023.patch,
    mozilla-aarch64-bmo-963024.patch,
    mozilla-aarch64-bmo-963031.patch: AArch64 porting
* Mon Mar 24 2014 dvaleev@suse.com
- Add patch for bmo#973977
  * mozilla-ppc64-xpcom.patch
* Mon Mar 24 2014 dvaleev@suse.com
- Refresh mozilla-ppc64le-xpcom.patch patch
* Fri Mar 21 2014 dvaleev@suse.com
- Adapt mozilla-ppc64le-xpcom.patch to Mozilla > 24.0 build system
* Sun Mar 16 2014 wr@rosenauer.org
- update to Firefox 28.0 (bnc#868603)
  * MFSA 2014-15/CVE-2014-1493/CVE-2014-1494
    Miscellaneous memory safety hazards
  * MFSA 2014-17/CVE-2014-1497 (bmo#966311)
    Out of bounds read during WAV file decoding
  * MFSA 2014-18/CVE-2014-1498 (bmo#935618)
    crypto.generateCRMFRequest does not validate type of key
  * MFSA 2014-19/CVE-2014-1499 (bmo#961512)
    Spoofing attack on WebRTC permission prompt
  * MFSA 2014-20/CVE-2014-1500 (bmo#956524)
    onbeforeunload and Javascript navigation DOS
  * MFSA 2014-22/CVE-2014-1502 (bmo#972622)
    WebGL content injection from one domain to rendering in another
  * MFSA 2014-23/CVE-2014-1504 (bmo#911547)
    Content Security Policy for data: documents not preserved by
    session restore
  * MFSA 2014-26/CVE-2014-1508 (bmo#963198)
    Information disclosure through polygon rendering in MathML
  * MFSA 2014-27/CVE-2014-1509 (bmo#966021)
    Memory corruption in Cairo during PDF font rendering
  * MFSA 2014-28/CVE-2014-1505 (bmo#941887)
    SVG filters information disclosure through feDisplacementMap
  * MFSA 2014-29/CVE-2014-1510/CVE-2014-1511 (bmo#982906, bmo#982909)
    Privilege escalation using WebIDL-implemented APIs
  * MFSA 2014-30/CVE-2014-1512 (bmo#982957)
    Use-after-free in TypeObject
  * MFSA 2014-31/CVE-2014-1513 (bmo#982974)
    Out-of-bounds read/write through neutering ArrayBuffer objects
  * MFSA 2014-32/CVE-2014-1514 (bmo#983344)
    Out-of-bounds write through TypedArrayObject after neutering
- requires NSPR 4.10.3 and NSS 3.15.5
- new build dependency (and recommends):
  * libpulse
- update of PowerPC 64 patches (bmo#976648) (pcerny@suse.com)
- rebased patches
* Mon Feb 17 2014 wr@rosenauer.org
- update to Firefox 27.0.1
  * Fixed stability issues with Greasemonkey and other JS that used
    ClearTimeoutOrInterval
  * JS math correctness issue (bmo#941381)
- incorporate Google API key for geolocation (bnc#864170)
- updated list of "other" locales in RPM requirements
* Tue Jan 28 2014 wr@rosenauer.org
- update to Firefox 27.0 (bnc#861847)
  * MFSA 2014-01/CVE-2014-1477/CVE-2014-1478
    Miscellaneous memory safety hazards (rv:27.0 / rv:24.3)
  * MFSA 2014-02/CVE-2014-1479 (bmo#911864)
    Clone protected content with XBL scopes
  * MFSA 2014-03/CVE-2014-1480 (bmo#916726)
    UI selection timeout missing on download prompts
  * MFSA 2014-04/CVE-2014-1482 (bmo#943803)
    Incorrect use of discarded images by RasterImage
  * MFSA 2014-05/CVE-2014-1483 (bmo#950427)
    Information disclosure with *FromPoint on iframes
  * MFSA 2014-06/CVE-2014-1484 (bmo#953993)
    Profile path leaks to Android system log
  * MFSA 2014-07/CVE-2014-1485 (bmo#910139)
    XSLT stylesheets treated as styles in Content Security Policy
  * MFSA 2014-08/CVE-2014-1486 (bmo#942164)
    Use-after-free with imgRequestProxy and image proccessing
  * MFSA 2014-09/CVE-2014-1487 (bmo#947592)
    Cross-origin information leak through web workers
  * MFSA 2014-10/CVE-2014-1489 (bmo#959531)
    Firefox default start page UI content invokable by script
  * MFSA 2014-11/CVE-2014-1488 (bmo#950604)
    Crash when using web workers with asm.js
  * MFSA 2014-12/CVE-2014-1490/CVE-2014-1491
    (bmo#934545, bmo#930874, bmo#930857)
    NSS ticket handling issues
  * MFSA 2014-13/CVE-2014-1481(bmo#936056)
    Inconsistent JavaScript handling of access to Window objects
- requires NSS 3.15.4 or higher
- rebased/reworked patches
- removed obsolete mozilla-bug929439.patch
* Thu Dec 12 2013 uweigand@de.ibm.com
- Add support for powerpc64le-linux.
  * mozilla-ppc64le.patch: general support
  * mozilla-libffi-ppc64le.patch: libffi backport
  * mozilla-xpcom-ppc64le.patch: port xpcom
- Add build fix from mainline.
  * mozilla-bug929439.patch
* Sun Dec  8 2013 wr@rosenauer.org
- update to Firefox 26.0 (bnc#854367, bnc#854370)
  * rebased patches
  * requires NSPR 4.10.2 and NSS 3.15.3.1
  * MFSA 2013-104/CVE-2013-5609/CVE-2013-5610
    Miscellaneous memory safety hazards
  * MFSA 2013-105/CVE-2013-5611 (bmo#771294)
    Application Installation doorhanger persists on navigation
  * MFSA 2013-106/CVE-2013-5612 (bmo#871161)
    Character encoding cross-origin XSS attack
  * MFSA 2013-107/CVE-2013-5614 (bmo#886262)
    Sandbox restrictions not applied to nested object elements
  * MFSA 2013-108/CVE-2013-5616 (bmo#938341)
    Use-after-free in event listeners
  * MFSA 2013-109/CVE-2013-5618 (bmo#926361)
    Use-after-free during Table Editing
  * MFSA 2013-110/CVE-2013-5619 (bmo#917841)
    Potential overflow in JavaScript binary search algorithms
  * MFSA 2013-111/CVE-2013-6671 (bmo#930281)
    Segmentation violation when replacing ordered list elements
  * MFSA 2013-112/CVE-2013-6672 (bmo#894736)
    Linux clipboard information disclosure though selection paste
  * MFSA 2013-113/CVE-2013-6673 (bmo#970380)
    Trust settings for built-in roots ignored during EV certificate
    validation
  * MFSA 2013-114/CVE-2013-5613 (bmo#930381, bmo#932449)
    Use-after-free in synthetic mouse movement
  * MFSA 2013-115/CVE-2013-5615 (bmo#929261)
    GetElementIC typed array stubs can be generated outside observed
    typesets
  * MFSA 2013-116/CVE-2013-6629/CVE-2013-6630 (bmo#891693)
    JPEG information leak
  * MFSA 2013-117 (bmo#946351)
    Mis-issued ANSSI/DCSSI certificate
    (fixed via NSS 3.15.3.1)
- removed gecko.js preference file as GStreamer is enabled by
  default now
* Thu Oct 24 2013 wr@rosenauer.org
- update to Firefox 25.0 (bnc#847708)
  * rebased patches
  * requires NSS 3.15.2 or above
  * MFSA 2013-93/CVE-2013-5590/CVE-2013-5591/CVE-2013-5592
    Miscellaneous memory safety hazards
  * MFSA 2013-94/CVE-2013-5593 (bmo#868327)
    Spoofing addressbar through SELECT element
  * MFSA 2013-95/CVE-2013-5604 (bmo#914017)
    Access violation with XSLT and uninitialized data
  * MFSA 2013-96/CVE-2013-5595 (bmo#916580)
    Improperly initialized memory and overflows in some JavaScript
    functions
  * MFSA 2013-97/CVE-2013-5596 (bmo#910881)
    Writing to cycle collected object during image decoding
  * MFSA 2013-98/CVE-2013-5597 (bmo#918864)
    Use-after-free when updating offline cache
  * MFSA 2013-99/CVE-2013-5598 (bmo#920515)
    Security bypass of PDF.js checks using iframes
  * MFSA 2013-100/CVE-2013-5599/CVE-2013-5600/CVE-2013-5601
    (bmo#915210, bmo#915576, bmo#916685)
    Miscellaneous use-after-free issues found through ASAN fuzzing
  * MFSA 2013-101/CVE-2013-5602 (bmo#897678)
    Memory corruption in workers
  * MFSA 2013-102/CVE-2013-5603 (bmo#916404)
    Use-after-free in HTML document templates
* Tue Sep 24 2013 wr@rosenauer.org
- as GStreamer is not automatically required anymore but loaded
  dynamically if available, require it explicitely
- recommend optional GStreamer plugins for comprehensive media
  support
* Mon Sep 16 2013 lnussel@suse.de
- move greek to the translations-common package (bnc#840551)
* Sat Sep 14 2013 wr@rosenauer.org
- update to Firefox 24.0 (bnc#840485)
  * MFSA 2013-76/CVE-2013-1718/CVE-2013-1719
    Miscellaneous memory safety hazards
  * MFSA 2013-77/CVE-2013-1720 (bmo#888820)
    Improper state in HTML5 Tree Builder with templates
  * MFSA 2013-78/CVE-2013-1721 (bmo#890277)
    Integer overflow in ANGLE library
  * MFSA 2013-79/CVE-2013-1722 (bmo#893308)
    Use-after-free in Animation Manager during stylesheet cloning
  * MFSA 2013-80/CVE-2013-1723 (bmo#891292)
    NativeKey continues handling key messages after widget is destroyed
  * MFSA 2013-81/CVE-2013-1724 (bmo#894137)
    Use-after-free with select element
  * MFSA 2013-82/CVE-2013-1725 (bmo#876762)
    Calling scope for new Javascript objects can lead to memory corruption
  * MFSA 2013-85/CVE-2013-1728 (bmo#883686)
    Uninitialized data in IonMonkey
  * MFSA 2013-88/CVE-2013-1730 (bmo#851353)
    Compartment mismatch re-attaching XBL-backed nodes
  * MFSA 2013-89/CVE-2013-1732 (bmo#883514)
    Buffer overflow with multi-column, lists, and floats
  * MFSA 2013-90/CVE-2013-1735/CVE-2013-1736 (bmo#898871, bmo#906301)
    Memory corruption involving scrolling
  * MFSA 2013-91/CVE-2013-1737 (bmo#907727)
    User-defined properties on DOM proxies get the wrong "this" object
  * MFSA 2013-92/CVE-2013-1738 (bmo#887334, bmo#882897)
    GC hazard with default compartments and frame chain restoration
- enable gstreamer explicitely via pref (gecko.js)
- require NSS 3.15.1
* Mon Aug 26 2013 wr@rosenauer.org
- update to Firefox 23.0.1
  * Audio static/"burble"/breakup in Firefox to Firefox WebRTC calls
    (bmo#901527)
* Sun Aug  4 2013 wr@rosenauer.org
- update to Firefox 23.0 (bnc#833389)
  * MFSA 2013-63/CVE-2013-1701/CVE-2013-1702
    Miscellaneous memory safety hazards
  * MFSA 2013-64/CVE-2013-1704 (bmo#883313)
    Use after free mutating DOM during SetBody
  * MFSA 2013-65/CVE-2013-1705 (bmo#882865)
    Buffer underflow when generating CRMF requests
  * MFSA 2013-67/CVE-2013-1708 (bmo#879924)
    Crash during WAV audio file decoding
  * MFSA 2013-68/CVE-2013-1709 (bmo#838253)
    Document URI misrepresentation and masquerading
  * MFSA 2013-69/CVE-2013-1710 (bmo#871368)
    CRMF requests allow for code execution and XSS attacks
  * MFSA 2013-70/CVE-2013-1711 (bmo#843829)
    Bypass of XrayWrappers using XBL Scopes
  * MFSA 2013-72/CVE-2013-1713 (bmo#887098)
    Wrong principal used for validating URI for some Javascript
    components
  * MFSA 2013-73/CVE-2013-1714 (bmo#879787)
    Same-origin bypass with web workers and XMLHttpRequest
  * MFSA 2013-75/CVE-2013-1717 (bmo#406541, bmo#738397)
    Local Java applets may read contents of local file system
- requires NSPR 4.10 and NSS 3.15
* Wed Jul  3 2013 dmueller@suse.com
- fix build on ARM (/-g/ matches /-grecord-switches/)
* Sat Jun 22 2013 wr@rosenauer.org
- update to Firefox 22.0 (bnc#825935)
  * removed obsolete patches
    + mozilla-qcms-ppc.patch
    + mozilla-gstreamer-760140.patch
  * GStreamer support does not build on 12.1 anymore (build only
    on 12.2 and later)
  * MFSA 2013-49/CVE-2013-1682/CVE-2013-1683
    Miscellaneous memory safety hazards
  * MFSA 2013-50/CVE-2013-1684/CVE-2013-1685/CVE-2013-1686
    Memory corruption found using Address Sanitizer
  * MFSA 2013-51/CVE-2013-1687 (bmo#863933, bmo#866823)
    Privileged content access and execution via XBL
  * MFSA 2013-52/CVE-2013-1688 (bmo#873966)
    Arbitrary code execution within Profiler
  * MFSA 2013-53/CVE-2013-1690 (bmo#857883)
    Execution of unmapped memory through onreadystatechange event
  * MFSA 2013-54/CVE-2013-1692 (bmo#866915)
    Data in the body of XHR HEAD requests leads to CSRF attacks
  * MFSA 2013-55/CVE-2013-1693 (bmo#711043)
    SVG filters can lead to information disclosure
  * MFSA 2013-56/CVE-2013-1694 (bmo#848535)
    PreserveWrapper has inconsistent behavior
  * MFSA 2013-57/CVE-2013-1695 (bmo#849791)
    Sandbox restrictions not applied to nested frame elements
  * MFSA 2013-58/CVE-2013-1696 (bmo#761667)
    X-Frame-Options ignored when using server push with multi-part
    responses
  * MFSA 2013-59/CVE-2013-1697 (bmo#858101)
    XrayWrappers can be bypassed to run user defined methods in a
    privileged context
  * MFSA 2013-60/CVE-2013-1698 (bmo#876044)
    getUserMedia permission dialog incorrectly displays location
  * MFSA 2013-61/CVE-2013-1699 (bmo#840882)
    Homograph domain spoofing in .com, .net and .name
* Tue Jun 11 2013 dvaleev@suse.com
- Fix qcms altivec include (mozilla-qcms-ppc.patch)
* Fri May 10 2013 wr@rosenauer.org
- update to Firefox 21.0 (bnc#819204)
  * removed upstreamed patch firefox-712763.patch
  * removed disabled mozilla-disable-neon-option.patch
  * MFSA 2013-41/CVE-2013-0801/CVE-2013-1669
    Miscellaneous memory safety hazards
  * MFSA 2013-42/CVE-2013-1670 (bmo#853709)
    Privileged access for content level constructor
  * MFSA 2013-43/CVE-2013-1671 (bmo#842255)
    File input control has access to full path
  * MFSA 2013-46/CVE-2013-1674 (bmo#860971)
    Use-after-free with video and onresize event
  * MFSA 2013-47/CVE-2013-1675 (bmo#866825)
    Uninitialized functions in DOMSVGZoomEvent
  * MFSA 2013-48/CVE-2013-1676/CVE-2013-1677/CVE-2013-1678/
    CVE-2013-1679/CVE-2013-1680/CVE-2013-1681
    Memory corruption found using Address Sanitizer
* Tue Apr  9 2013 wr@rosenauer.org
- revert to use GStreamer 0.10 on 12.3 (bnc#814101)
  (remove mozilla-gstreamer-1.patch)
* Fri Apr  5 2013 schwab@linux-m68k.org
- Explicitly disable WebRTC support on non-x86, the configure script
  disables it only half-heartedly
* Fri Mar 29 2013 wr@rosenauer.org
- update to Firefox 20.0 (bnc#813026)
  * requires NSPR 4.9.5 and NSS 3.14.3
  * mozilla-webrtc-ppc.patch included upstream
  * MFSA 2013-30/CVE-2013-0788/CVE-2013-0789
    Miscellaneous memory safety hazards
  * MFSA 2013-31/CVE-2013-0800 (bmo#825721)
    Out-of-bounds write in Cairo library
  * MFSA 2013-35/CVE-2013-0796 (bmo#827106)
    WebGL crash with Mesa graphics driver on Linux
  * MFSA 2013-36/CVE-2013-0795 (bmo#825697)
    Bypass of SOW protections allows cloning of protected nodes
  * MFSA 2013-37/CVE-2013-0794 (bmo#626775)
    Bypass of tab-modal dialog origin disclosure
  * MFSA 2013-38/CVE-2013-0793 (bmo#803870)
    Cross-site scripting (XSS) using timed history navigations
  * MFSA 2013-39/CVE-2013-0792 (bmo#722831)
    Memory corruption while rendering grayscale PNG images
- use GStreamer 1.0 starting with 12.3 (mozilla-gstreamer-1.patch)
* Tue Mar 12 2013 dmueller@suse.com
- build fixes for armv7hl:
  * disable debug build as armv7hl does not have enough memory
  * disable webrtc on armv7hl as it is non-compiling
* Thu Mar  7 2013 wr@rosenauer.org
- update to Firefox 19.0.2 (bnc#808243)
  * MFSA 2013-29/CVE-2013-0787 (bmo#848644)
    Use-after-free in HTML Editor
* Thu Feb 28 2013 wr@rosenauer.org
- update to Firefox 19.0.1
  * blocklist updates
* Sat Feb 16 2013 wr@rosenauer.org
- update to Firefox 19.0 (bnc#804248)
  * MFSA 2013-21/CVE-2013-0783/2013-0784
    Miscellaneous memory safety hazards
  * MFSA 2013-22/CVE-2013-0772 (bmo#801366)
    Out-of-bounds read in image rendering
  * MFSA 2013-23/CVE-2013-0765 (bmo#830614)
    Wrapped WebIDL objects can be wrapped again
  * MFSA 2013-24/CVE-2013-0773 (bmo#809652)
    Web content bypass of COW and SOW security wrappers
  * MFSA 2013-25/CVE-2013-0774 (bmo#827193)
    Privacy leak in JavaScript Workers
  * MFSA 2013-26/CVE-2013-0775 (bmo#831095)
    Use-after-free in nsImageLoadingContent
  * MFSA 2013-27/CVE-2013-0776 (bmo#796475)
    Phishing on HTTPS connection through malicious proxy
  * MFSA 2013-28/CVE-2013-0780/CVE-2013-0782/CVE-2013-0777/
    CVE-2013-0778/CVE-2013-0779/CVE-2013-0781
    Use-after-free, out of bounds read, and buffer overflow issues
    found using Address Sanitizer
- removed obsolete patches
  * mozilla-webrtc.patch
  * mozilla-gstreamer-803287.patch
- added patch to fix session restore window order (bmo#712763)
* Sat Feb  2 2013 wr@rosenauer.org
- update to Firefox 18.0.2
  * blocklist and CTP updates
  * fixes in JS engine
* Wed Jan 16 2013 wr@rosenauer.org
- update to Firefox 18.0.1
  * blocklist updates
  * backed out bmo#677092 (removed patch)
  * fixed problems involving HTTP proxy transactions
* Sat Jan 12 2013 schwab@linux-m68k.org
- Fix WebRTC to build on powerpc
* Sun Jan  6 2013 wr@rosenauer.org
- update to Firefox 18.0 (bnc#796895)
  * MFSA 2013-01/CVE-2013-0749/CVE-2013-0769/CVE-2013-0770
    Miscellaneous memory safety hazards
  * MFSA 2013-02/CVE-2013-0760/CVE-2013-0762/CVE-2013-0766/CVE-2013-0767
    CVE-2013-0761/CVE-2013-0763/CVE-2013-0771/CVE-2012-5829
    Use-after-free and buffer overflow issues found using Address Sanitizer
  * MFSA 2013-03/CVE-2013-0768 (bmo#815795)
    Buffer Overflow in Canvas
  * MFSA 2013-04/CVE-2012-0759 (bmo#802026)
    URL spoofing in addressbar during page loads
  * MFSA 2013-05/CVE-2013-0744 (bmo#814713)
    Use-after-free when displaying table with many columns and column groups
  * MFSA 2013-06/CVE-2013-0751 (bmo#790454)
    Touch events are shared across iframes
  * MFSA 2013-07/CVE-2013-0764 (bmo#804237)
    Crash due to handling of SSL on threads
  * MFSA 2013-08/CVE-2013-0745 (bmo#794158)
    AutoWrapperChanger fails to keep objects alive during garbage collection
  * MFSA 2013-09/CVE-2013-0746 (bmo#816842)
    Compartment mismatch with quickstubs returned values
  * MFSA 2013-10/CVE-2013-0747 (bmo#733305)
    Event manipulation in plugin handler to bypass same-origin policy
  * MFSA 2013-11/CVE-2013-0748 (bmo#806031)
    Address space layout leaked in XBL objects
  * MFSA 2013-12/CVE-2013-0750 (bmo#805121)
    Buffer overflow in Javascript string concatenation
  * MFSA 2013-13/CVE-2013-0752 (bmo#805024)
    Memory corruption in XBL with XML bindings containing SVG
  * MFSA 2013-14/CVE-2013-0757 (bmo#813901)
    Chrome Object Wrapper (COW) bypass through changing prototype
  * MFSA 2013-15/CVE-2013-0758 (bmo#813906)
    Privilege escalation through plugin objects
  * MFSA 2013-16/CVE-2013-0753 (bmo#814001)
    Use-after-free in serializeToStream
  * MFSA 2013-17/CVE-2013-0754 (bmo#814026)
    Use-after-free in ListenerManager
  * MFSA 2013-18/CVE-2013-0755 (bmo#814027)
    Use-after-free in Vibrate
  * MFSA 2013-19/CVE-2013-0756 (bmo#814029)
    Use-after-free in Javascript Proxy objects
- requires NSS 3.14.1 (MFSA 2013-20, CVE-2013-0743)
- removed obsolete SLE11 patches (mozilla-gcc43*)
- reenable WebRTC
- added mozilla-libproxy-compat.patch for libproxy API compat
  on openSUSE 11.2 and earlier
- backed out restartless language packs as it broke multi-locale
  setup (bmo#677092, bmo#818468)
* Thu Nov 29 2012 wr@rosenauer.org
- update to Firefox 17.0.1
  * revert some useragent changes introduced in 17.0
  * leaving private browsing with social enabled doesn't reset all
    social components (bmo#815042)
- fix KDE integration for file dialogs
* Tue Nov 20 2012 wr@rosenauer.org
- update to Firefox 17.0 (bnc#790140)
  * MFSA 2012-91/CVE-2012-5842/CVE-2012-5843
    Miscellaneous memory safety hazards
  * MFSA 2012-92/CVE-2012-4202 (bmo#758200)
    Buffer overflow while rendering GIF images
  * MFSA 2012-93/CVE-2012-4201 (bmo#747607)
    evalInSanbox location context incorrectly applied
  * MFSA 2012-94/CVE-2012-5836 (bmo#792857)
    Crash when combining SVG text on path with CSS
  * MFSA 2012-95/CVE-2012-4203 (bmo#765628)
    Javascript: URLs run in privileged context on New Tab page
  * MFSA 2012-96/CVE-2012-4204 (bmo#778603)
    Memory corruption in str_unescape
  * MFSA 2012-97/CVE-2012-4205 (bmo#779821)
    XMLHttpRequest inherits incorrect principal within sandbox
  * MFSA 2012-99/CVE-2012-4208 (bmo#798264)
    XrayWrappers exposes chrome-only properties when not in chrome
    compartment
  * MFSA 2012-100/CVE-2012-5841 (bmo#805807)
    Improper security filtering for cross-origin wrappers
  * MFSA 2012-101/CVE-2012-4207 (bmo#801681)
    Improper character decoding in HZ-GB-2312 charset
  * MFSA 2012-102/CVE-2012-5837 (bmo#800363)
    Script entered into Developer Toolbar runs with chrome privileges
  * MFSA 2012-103/CVE-2012-4209 (bmo#792405)
    Frames can shadow top.location
  * MFSA 2012-104/CVE-2012-4210 (bmo#796866)
    CSS and HTML injection through Style Inspector
  * MFSA 2012-105/CVE-2012-4214/CVE-2012-4215/CVE-2012-4216/
    CVE-2012-5829/CVE-2012-5839/CVE-2012-5840/CVE-2012-4212/
    CVE-2012-4213/CVE-2012-4217/CVE-2012-4218
    Use-after-free and buffer overflow issues found using Address
    Sanitizer
  * MFSA 2012-106/CVE-2012-5830/CVE-2012-5833/CVE-2012-5835/CVE-2012-5838
    Use-after-free, buffer overflow, and memory corruption issues
    found using Address Sanitizer
- rebased patches
- disabled WebRTC since build is broken (bmo#776877)
* Tue Nov 20 2012 pcerny@suse.com
- build on SLE11
  * mozilla-gcc43-enums.patch
  * mozilla-gcc43-template_hacks.patch
  * mozilla-gcc43-templates_instantiation.patch
* Wed Oct 24 2012 wr@rosenauer.org
- update to Firefox 16.0.2 (bnc#786522)
  * MFSA 2012-90/CVE-2012-4194/CVE-2012-4195/CVE-2012-4196
    (bmo#800666, bmo#793121, bmo#802557)
    Fixes for Location object issues
- bring back Obsoletes for libproxy's mozjs plugin for distributions
  before 12.2 to avoid crashes
* Thu Oct 11 2012 wr@rosenauer.org
- update to Firefox 16.0.1 (bnc#783533)
  * MFSA 2012-88/CVE-2012-4191 (bmo#798045)
    Miscellaneous memory safety hazards
  * MFSA 2012-89/CVE-2012-4192/CVE-2012-4193 (bmo#799952, bmo#720619)
    defaultValue security checks not applied
* Sun Oct  7 2012 wr@rosenauer.org
- update to Firefox 16.0 (bnc#783533)
  * MFSA 2012-74/CVE-2012-3982/CVE-2012-3983
    Miscellaneous memory safety hazards
  * MFSA 2012-75/CVE-2012-3984 (bmo#575294)
    select element persistance allows for attacks
  * MFSA 2012-76/CVE-2012-3985 (bmo#655649)
    Continued access to initial origin after setting document.domain
  * MFSA 2012-77/CVE-2012-3986 (bmo#775868)
    Some DOMWindowUtils methods bypass security checks
  * MFSA 2012-79/CVE-2012-3988 (bmo#725770)
    DOS and crash with full screen and history navigation
  * MFSA 2012-80/CVE-2012-3989 (bmo#783867)
    Crash with invalid cast when using instanceof operator
  * MFSA 2012-81/CVE-2012-3991 (bmo#783260)
    GetProperty function can bypass security checks
  * MFSA 2012-82/CVE-2012-3994 (bmo#765527)
    top object and location property accessible by plugins
  * MFSA 2012-83/CVE-2012-3993/CVE-2012-4184 (bmo#768101, bmo#780370)
    Chrome Object Wrapper (COW) does not disallow acces to privileged
    functions or properties
  * MFSA 2012-84/CVE-2012-3992 (bmo#775009)
    Spoofing and script injection through location.hash
  * MFSA 2012-85/CVE-2012-3995/CVE-2012-4179/CVE-2012-4180/
    CVE-2012-4181/CVE-2012-4182/CVE-2012-4183
    Use-after-free, buffer overflow, and out of bounds read issues
    found using Address Sanitizer
  * MFSA 2012-86/CVE-2012-4185/CVE-2012-4186/CVE-2012-4187/
    CVE-2012-4188
    Heap memory corruption issues found using Address Sanitizer
  * MFSA 2012-87/CVE-2012-3990 (bmo#787704)
    Use-after-free in the IME State Manager
- requires NSPR 4.9.2
- improve GStreamer integration (bmo#760140)
- removed upstreamed mozilla-crashreporter-restart-args.patch
- webapprt now included
- use kmozillahelper's new REVEAL command (bnc#777415)
  (requires mozilla-kde4-integration >= 0.6.4)
- updated translations-other with new languages
* Mon Sep 10 2012 wr@rosenauer.org
- update to Firefox 15.0.1 (bnc#779936)
  * Sites visited while in Private Browsing mode could be found
    through manual browser cache inspection (bmo#787743)
* Sun Aug 26 2012 wr@rosenauer.org
- update to Firefox 15.0 (bnc#777588)
  * MFSA 2012-57/CVE-2012-1970
    Miscellaneous memory safety hazards
  * MFSA 2012-58/CVE-2012-1972/CVE-2012-1973/CVE-2012-1974/CVE-2012-1975
    CVE-2012-1976/CVE-2012-3956/CVE-2012-3957/CVE-2012-3958/CVE-2012-3959
    CVE-2012-3960/CVE-2012-3961/CVE-2012-3962/CVE-2012-3963/CVE-2012-3964
    Use-after-free issues found using Address Sanitizer
  * MFSA 2012-59/CVE-2012-1956 (bmo#756719)
    Location object can be shadowed using Object.defineProperty
  * MFSA 2012-60/CVE-2012-3965 (bmo#769108)
    Escalation of privilege through about:newtab
  * MFSA 2012-61/CVE-2012-3966 (bmo#775794, bmo#775793)
    Memory corruption with bitmap format images with negative height
  * MFSA 2012-62/CVE-2012-3967/CVE-2012-3968
    WebGL use-after-free and memory corruption
  * MFSA 2012-63/CVE-2012-3969/CVE-2012-3970
    SVG buffer overflow and use-after-free issues
  * MFSA 2012-64/CVE-2012-3971
    Graphite 2 memory corruption
  * MFSA 2012-65/CVE-2012-3972 (bmo#746855)
    Out-of-bounds read in format-number in XSLT
  * MFSA 2012-66/CVE-2012-3973 (bmo#757128)
    HTTPMonitor extension allows for remote debugging without explicit
    activation
  * MFSA 2012-68/CVE-2012-3975 (bmo#770684)
    DOMParser loads linked resources in extensions when parsing
    text/html
  * MFSA 2012-69/CVE-2012-3976 (bmo#768568)
    Incorrect site SSL certificate data display
  * MFSA 2012-70/CVE-2012-3978 (bmo#770429)
    Location object security checks bypassed by chrome code
  * MFSA 2012-72/CVE-2012-3980 (bmo#771859)
    Web console eval capable of executing chrome-privileged code
- fix HTML5 video crash with GStreamer enabled (bmo#761030)
- GStreamer is only used for MP4 (no WebM, OGG)
- updated filelist
- moved browser specific preferences to correct location
* Sun Jul 29 2012 aj@suse.de
- Fix mozilla-kde.patch to include sys/resource.h for getrlimit etc (glibc 2.16)
* Sat Jul 14 2012 wr@rosenauer.org
- update to 14.0.1 (bnc#771583)
  * MFSA 2012-42/CVE-2012-1949/CVE-2012-1948
    Miscellaneous memory safety hazards
  * MFSA 2012-43/CVE-2012-1950
    Incorrect URL displayed in addressbar through drag and drop
  * MFSA 2012-44/CVE-2012-1951/CVE-2012-1954/CVE-2012-1953/CVE-2012-1952
    Gecko memory corruption
  * MFSA 2012-45/CVE-2012-1955 (bmo#757376)
    Spoofing issue with location
  * MFSA 2012-46/CVE-2012-1966 (bmo#734076)
    XSS through data: URLs
  * MFSA 2012-47/CVE-2012-1957 (bmo#750096)
    Improper filtering of javascript in HTML feed-view
  * MFSA 2012-48/CVE-2012-1958 (bmo#750820)
    use-after-free in nsGlobalWindow::PageHidden
  * MFSA 2012-49/CVE-2012-1959 (bmo#754044, bmo#737559)
    Same-compartment Security Wrappers can be bypassed
  * MFSA 2012-50/CVE-2012-1960 (bmo#761014)
    Out of bounds read in QCMS
  * MFSA 2012-51/CVE-2012-1961 (bmo#761655)
    X-Frame-Options header ignored when duplicated
  * MFSA 2012-52/CVE-2012-1962 (bmo#764296)
    JSDependentString::undepend string conversion results in memory
    corruption
  * MFSA 2012-53/CVE-2012-1963 (bmo#767778)
    Content Security Policy 1.0 implementation errors cause data
    leakage
  * MFSA 2012-55/CVE-2012-1965 (bmo#758990)
    feed: URLs with an innerURI inherit security context of page
  * MFSA 2012-56/CVE-2012-1967 (bmo#758344)
    Code execution through javascript: URLs
- license change from tri license to MPL-2.0
- fix crashreporter restart option (bmo#762780)
- require NSS 3.13.5
- remove mozjs pacrunner obsoletes again for now
- adopted mozilla-prefer_plugin_pref.patch
- PPC fixes:
  * reenabled mozilla-yarr-pcre.patch to fix build for PPC
  * add patches for bmo#750620 and bmo#746112
  * fix xpcshell segfault on ppc
* Fri Jun 15 2012 wr@rosenauer.org
- update to Firefox 13.0.1
  * bugfix release
- obsolete libproxy's mozjs pacrunner (bnc#759123)
* Sat Jun  2 2012 wr@rosenauer.org
- update to Firefox 13.0 (bnc#765204)
  * MFSA 2012-34/CVE-2012-1938/CVE-2012-1937/CVE-2011-3101
    Miscellaneous memory safety hazards
  * MFSA 2012-36/CVE-2012-1944 (bmo#751422)
    Content Security Policy inline-script bypass
  * MFSA 2012-37/CVE-2012-1945 (bmo#670514)
    Information disclosure though Windows file shares and shortcut
    files
  * MFSA 2012-38/CVE-2012-1946 (bmo#750109)
    Use-after-free while replacing/inserting a node in a document
  * MFSA 2012-40/CVE-2012-1947/CVE-2012-1940/CVE-2012-1941
    Buffer overflow and use-after-free issues found using Address
    Sanitizer
- require NSS 3.13.4
  * MFSA 2012-39/CVE-2012-0441 (bmo#715073)
- fix sound notifications when filename/path contains a whitespace
  (bmo#749739)
* Wed May 23 2012 adrian@suse.de
- fix build on arm
* Wed May 16 2012 wr@rosenauer.org
- reenabled crashreporter for Factory/12.2
  (fix in mozilla-gcc47.patch)
* Sat Apr 21 2012 wr@rosenauer.org
- update to Firefox 12.0 (bnc#758408)
  * rebased patches
  * MFSA 2012-20/CVE-2012-0467/CVE-2012-0468
    Miscellaneous memory safety hazards
  * MFSA 2012-22/CVE-2012-0469 (bmo#738985)
    use-after-free in IDBKeyRange
  * MFSA 2012-23/CVE-2012-0470 (bmo#734288)
    Invalid frees causes heap corruption in gfxImageSurface
  * MFSA 2012-24/CVE-2012-0471 (bmo#715319)
    Potential XSS via multibyte content processing errors
  * MFSA 2012-25/CVE-2012-0472 (bmo#744480)
    Potential memory corruption during font rendering using cairo-dwrite
  * MFSA 2012-26/CVE-2012-0473 (bmo#743475)
    WebGL.drawElements may read illegal video memory due to
    FindMaxUshortElement error
  * MFSA 2012-27/CVE-2012-0474 (bmo#687745, bmo#737307)
    Page load short-circuit can lead to XSS
  * MFSA 2012-28/CVE-2012-0475 (bmo#694576)
    Ambiguous IPv6 in Origin headers may bypass webserver access
    restrictions
  * MFSA 2012-29/CVE-2012-0477 (bmo#718573)
    Potential XSS through ISO-2022-KR/ISO-2022-CN decoding issues
  * MFSA 2012-30/CVE-2012-0478 (bmo#727547)
    Crash with WebGL content using textImage2D
  * MFSA 2012-31/CVE-2011-3062 (bmo#739925)
    Off-by-one error in OpenType Sanitizer
  * MFSA 2012-32/CVE-2011-1187 (bmo#624621)
    HTTP Redirections and remote content can be read by javascript errors
  * MFSA 2012-33/CVE-2012-0479 (bmo#714631)
    Potential site identity spoofing when loading RSS and Atom feeds
- added mozilla-libnotify.patch to allow fallback from libnotify
  to xul based events if no notification-daemon is running
- gcc 4.7 fixes
  * mozilla-gcc47.patch
  * disabled crashreporter temporarily for Factory
- recommend libcanberra0 for proper sound notifications
* Fri Mar  9 2012 wr@rosenauer.org
- update to Firefox 11.0 (bnc#750044)
  * MFSA 2012-13/CVE-2012-0455 (bmo#704354)
    XSS with Drag and Drop and Javascript: URL
  * MFSA 2012-14/CVE-2012-0456/CVE-2012-0457 (bmo#711653, #720103)
    SVG issues found with Address Sanitizer
  * MFSA 2012-15/CVE-2012-0451 (bmo#717511)
    XSS with multiple Content Security Policy headers
  * MFSA 2012-16/CVE-2012-0458
    Escalation of privilege with Javascript: URL as home page
  * MFSA 2012-17/CVE-2012-0459 (bmo#723446)
    Crash when accessing keyframe cssText after dynamic modification
  * MFSA 2012-18/CVE-2012-0460 (bmo#727303)
    window.fullScreen writeable by untrusted content
  * MFSA 2012-19/CVE-2012-0461/CVE-2012-0462/CVE-2012-0464/
    CVE-2012-0463
    Miscellaneous memory safety hazards
- ported and reenabled KDE integration (bnc#746591)
- explicitely build-require X libs
* Mon Mar  5 2012 vdziewiecki@suse.com
- add Provides: browser(npapi) FATE#313084
* Fri Feb 17 2012 pcerny@suse.com
- better plugin directory resolution (bnc#747320)
* Thu Feb 16 2012 wr@rosenauer.org
- update to Firefox 10.0.2 (bnc#747328)
  * CVE-2011-3026 (bmo#727401)
    libpng: integer overflow leading to heap-buffer overflow
* Thu Feb  9 2012 wr@rosenauer.org
- update to Firefox 10.0.1 (bnc#746616)
  * MFSA 2012-10/CVE-2012-0452 (bmo#724284)
    use after free in nsXBLDocumentInfo::ReadPrototypeBindings
* Tue Feb  7 2012 dvaleev@suse.com
- Use YARR interpreter instead of PCRE on platforms where YARR JIT
  is not supported, since PCRE doesnt build (bmo#691898)
- fix ppc64 build (bmo#703534)
* Mon Jan 30 2012 wr@rosenauer.org
- update to Firefox 10.0 (bnc#744275)
  * MFSA 2012-01/CVE-2012-0442/CVE-2012-0443
    Miscellaneous memory safety hazards
  * MFSA 2012-03/CVE-2012-0445 (bmo#701071)
    <iframe> element exposed across domains via name attribute
  * MFSA 2012-04/CVE-2011-3659 (bmo#708198)
    Child nodes from nsDOMAttribute still accessible after removal
    of nodes
  * MFSA 2012-05/CVE-2012-0446 (bmo#705651)
    Frame scripts calling into untrusted objects bypass security
    checks
  * MFSA 2012-06/CVE-2012-0447 (bmo#710079)
    Uninitialized memory appended when encoding icon images may
    cause information disclosure
  * MFSA 2012-07/CVE-2012-0444 (bmo#719612)
    Potential Memory Corruption When Decoding Ogg Vorbis files
  * MFSA 2012-08/CVE-2012-0449 (bmo#701806, bmo#702466)
    Crash with malformed embedded XSLT stylesheets
- KDE integration has been disabled since it needs refactoring
- removed obsolete ppc64 patch
* Sun Jan 22 2012 joop.boonen@opensuse.org
- Disable neon for arm as it doesn't build correctly
* Fri Dec 23 2011 wr@rosenauer.org
- update to Firefox 9.0.1
  * (strongparent) parentNode of element gets lost (bmo#335998)
* Sun Dec 18 2011 adrian@suse.de
- fix arm build, don't package crashreporter there
* Sun Dec 18 2011 wr@rosenauer.org
- update to Firefox 9 (bnc#737533)
  * MFSA 2011-53/CVE-2011-3660
    Miscellaneous memory safety hazards (rv:9.0)
  * MFSA 2011-54/CVE-2011-3661 (bmo#691299)
    Potentially exploitable crash in the YARR regular expression
    library
  * MFSA 2011-55/CVE-2011-3658 (bmo#708186)
    nsSVGValue out-of-bounds access
  * MFSA 2011-56/CVE-2011-3663 (bmo#704482)
    Key detection without JavaScript via SVG animation
  * MFSA 2011-58/VE-2011-3665 (bmo#701259)
    Crash scaling <video> to extreme sizes
* Sun Nov 27 2011 mgorse@suse.com
- Fix accessibility under GNOME 3 (bnc#732898)
* Sat Nov 12 2011 dvaleev@suse.com
- fix ppc64 build
* Sun Nov  6 2011 wr@rosenauer.org
- update to Firefox 8 (bnc#728520)
  * MFSA 2011-47/CVE-2011-3648 (bmo#690225)
    Potential XSS against sites using Shift-JIS
  * MFSA 2011-48/CVE-2011-3651/CVE-2011-3652/CVE-2011-3654
    Miscellaneous memory safety hazards
  * MFSA 2011-49/CVE-2011-3650 (bmo#674776)
    Memory corruption while profiling using Firebug
  * MFSA 2011-52/CVE-2011-3655 (bmo#672182)
    Code execution via NoWaiverWrapper
- rebased patches
* Thu Oct 20 2011 wr@rosenauer.org
- enable telemetry prompt
* Fri Sep 30 2011 wr@rosenauer.org
- update to minor release 7.0.1
  * fixed staged addon updates
- set intl.locale.matchOS=true in the base package as it causes
  too much confusion when it's only available with branding-openSUSE
* Fri Sep 23 2011 wr@rosenauer.org
- update to Firefox 7 (bnc#720264)
  including
  * Improve Responsiveness with Memory Reductions
  * Instant Sync
  * WebSocket protocol 8
  * MFSA 2011-36/CVE-2011-2995/CVE-2011-2996/CVE-2011-2997
    Miscellaneous memory safety hazards
  * MFSA 2011-39/CVE-2011-3000 (bmo#655389)
    Defense against multiple Location headers due to CRLF Injection
  * MFSA 2011-40/CVE-2011-2372/CVE-2011-3001
    Code installation through holding down Enter
  * MFSA 2011-41/CVE-2011-3002/CVE-2011-3003 (bmo#680840, bmo#682335)
    Potentially exploitable WebGL crashes
  * MFSA 2011-42/CVE-2011-3232 (bmo#653672)
    Potentially exploitable crash in the YARR regular expression
    library
  * MFSA 2011-43/CVE-2011-3004 (bmo#653926)
    loadSubScript unwraps XPCNativeWrapper scope parameter
  * MFSA 2011-44/CVE-2011-3005 (bmo#675747)
    Use after free reading OGG headers
  * MFSA 2011-45
    Inferring keystrokes from motion data
- removed obsolete mozilla-cairo-lcd.patch
- rebased patches
- removed XLIB_SKIP_ARGB_VISUALS=1 from environment in
  mozilla.sh.in (bnc#680758)
* Fri Sep 16 2011 wr@rosenauer.org
- fixed loading of kde.js under KDE (bnc#718311)
* Wed Sep 14 2011 wr@rosenauer.org
- add dbus-1-glib-devel to BuildRequires (not pulled in
  automatically anymore on 12.1)
- increase minversions for NSPR and NSS
* Fri Sep  9 2011 wr@rosenauer.org
- recreated source archive to get correct source-stamp.txt
* Wed Sep  7 2011 pcerny@suse.com
- security update to 6.0.2 (bnc#714931)
  * Complete blocking of certificates issued by DigiNotar
    (bmo#683449)
* Fri Sep  2 2011 pcerny@suse.com
- security update to 6.0.1 (bnc#714931)
  * MFSA 2011-34
    Protection against fraudulent DigiNotar certificates
    (bmo#682927)
* Fri Aug 12 2011 wr@rosenauer.org
- update to 6.0 (bnc#712224)
  included security fixes MFSA 2011-29
  * CVE-2011-2989/CVE-2011-2991/CVE-2011-2992/CVE-2011-2985
    Miscellaneous memory safety hazards
  * CVE-2011-2993 (bmo#657267)
    Unsigned scripts can call script inside signed JAR
  * CVE-2011-2988 (bmo#665934)
    Heap overflow in ANGLE library
  * CVE-2011-0084 (bmo#648094)
    Crash in SVGTextElement.getCharNumAtPosition()
  * CVE-2011-2990
    Credential leakage using Content Security Policy reports
  * CVE-2011-2986 (bmo#655836)
    Cross-origin data theft using canvas and Windows D2D
- removed obsolete curl header dependency (mozilla-curl.patch)
* Fri Jul 22 2011 wr@rosenauer.org
- update to 6.0b3
  * removed obsolete patches
  - firefox-shellservice.patch
  - mozilla-gio.patch
  - mozilla-ppc-ipc.patch
  - firefox-linkorder.patch
  - firefox-no-sync-l10n.patch
- recognize linux3 as platform for symbolstore.py
* Fri Jul  1 2011 vuntz@opensuse.org
- Add x-scheme-handler/ftp to the MimeType key in the .desktop, to
  let desktops know that Firefox can deal with ftp: URIs.
* Fri Jul  1 2011 wr@rosenauer.org
- create upstream branding package again (supposedly empty)
  (bnc#703401)
- fix build on SLE11 (changes do not affect/are not applied for
  later versions)
* Wed Jun 22 2011 wr@rosenauer.org
- enable startup notification (bnc#701465)
* Mon Jun 20 2011 wr@rosenauer.org
- update to 5.0 final
- included fixes for security issues: (bnc#701296, bnc#700578)
  * MFSA 2011-19/CVE-2011-2374 CVE-2011-2375
    Miscellaneous memory safety hazards
  * MFSA 2011-20/CVE-2011-2373 (bmo#617247)
    Use-after-free vulnerability when viewing XUL document with
    script disabled
  * MFSA 2011-21/CVE-2011-2377 (bmo#638018, bmo#639303)
    Memory corruption due to multipart/x-mixed-replace images
  * MFSA 2011-22/CVE-2011-2371 (bmo#664009)
    Integer overflow and arbitrary code execution in
    Array.reduceRight()
  * MFSA 2011-25/CVE-2011-2366
    Stealing of cross-domain images using WebGL textures
  * MFSA 2011-26/CVE-2011-2367 CVE-2011-2368
    Multiple WebGL crashes
  * MFSA 2011-27/CVE-2011-2369 (bmo#650001)
    XSS encoding hazard with inline SVG
  * MFSA 2011-28/CVE-2011-2370 (bmo#645699)
    Non-whitelisted site can trigger xpinstall
* Mon Jun 20 2011 wr@rosenauer.org
- update to 5.0b7
  * updated supported locales
- do not build dump_syms static (not needed for us)
  - > fix build for openSUSE 12.1 and above
* Wed Jun 15 2011 wr@rosenauer.org
- update to 5.0b6
- include proper revision information into the build
- speedier find-external-requires.sh
* Tue May 31 2011 wr@rosenauer.org
- update to 5.0b3
- transformed to standalone Firefox (not xulrunner based)
  (with new Firefox rapid release cycle it makes no sense anymore)
  * imported all relevant xulrunner patches
- do not compile in build timestamp
* Fri Apr 15 2011 wr@rosenauer.org
- security update to 4.0.1 (bnc#689281)
  * MFSA 2011-12/ CVE-2011-0069 CVE-2011-0070 CVE-2011-0079
    CVE-2011-0080 CVE-2011-0081
    Miscellaneous memory safety hazards
  * MFSA 2011-17/CVE-2011-0068 (bmo#623791)
    WebGLES vulnerabilities
  * MFSA 2011-18/CVE-2011-1202 (bmo#640339)
    XSLT generate-id() function heap address leak
* Wed Mar 30 2011 wr@rosenauer.org
- add all available icon sizes
* Tue Mar 29 2011 cfarrell@novell.com
- license update: MPLv1.1 or GPLv2+ or LGPLv2+
  Sync licenses with Fedora. MPL does not state ^or later^
* Fri Mar 18 2011 wr@rosenauer.org
- update to version 4.0rc2
- fixed rpm macros delivered with devel package (bnc#679950)
* Wed Feb 23 2011 wr@rosenauer.org
- update to version 4.0b12
- rebased patches
* Fri Feb  4 2011 wr@rosenauer.org
- update to version 4.0b11
  * loads of bugfixes compared to last beta
  * added "Do Not Track" option
- rebased patches
- disable testpilot
* Fri Jan 28 2011 wr@rosenauer.org
- set correct desktop file name within KDE for 11.4 and up
- add devel package with macros for extensions (from lnussel@suse.de)
* Sat Jan 22 2011 wr@rosenauer.org
- update to version 4.0b10
- removed obsolete firefox-shell-bmo624267.patch
- testpilot moved to distribution/extensions
- updated locale provides and removed bn-IN from locales
* Tue Jan 11 2011 wr@rosenauer.org
- update to version 4.0b9
- added x-scheme-handler for http and https to desktop file for
  newer Gnome environments
- fixed default browser check/set for GIO (bmo#611953)
  (mozilla-shellservice.patch)
- removed obsolete firefox-appname.patch (integrated into
  shellservice patch)
- renamed desktop file to firefox.desktop for 11.4 and newer
  (bnc#664211)
- removed support for 10.3 and older from the spec file
- removed obsolete "Ximian" categories from desktop file
* Mon Jan  3 2011 meissner@suse.de
- Mirror ac_add_options --disable-ipc from xulrunner for PowerPC.
* Wed Dec 15 2010 wr@rosenauer.org
- update to version 4.0beta8
* Tue Nov 30 2010 wr@rosenauer.org
- major update to version 4.0beta7
  * based on mozilla-xulrunner20
  * far too many internal changes to list
* Wed Oct 27 2010 wr@rosenauer.org
- security update to 3.6.12 (bnc#649492)
  * MFSA 2010-73/CVE-2010-3765 (bmo#607222)
    Heap buffer overflow mixing document.write and DOM insertion
* Wed Oct  6 2010 wr@rosenauer.org
- security update to 3.6.11 (bnc#645315)
  * MFSA 2010-64/CVE-2010-3174/CVE-2010-3175/CVE-2010-3176
    Miscellaneous memory safety hazards
  * MFSA 2010-65/CVE-2010-3179 (bmo#583077)
    Buffer overflow and memory corruption using document.write
  * MFSA 2010-66/CVE-2010-3180 (bmo#588929)
    Use-after-free error in nsBarProp
  * MFSA 2010-67/CVE-2010-3183 (bmo#598669)
    Dangling pointer vulnerability in LookupGetterOrSetter
  * MFSA 2010-68/CVE-2010-3177 (bmo#556734)
    XSS in gopher parser when parsing hrefs
  * MFSA 2010-69/CVE-2010-3178 (bmo#576616)
    Cross-site information disclosure via modal calls
  * MFSA 2010-70/CVE-2010-3170 (bmo#578697)
    SSL wildcard certificate matching IP addresses
  * MFSA 2010-71/CVE-2010-3182 (bmo#590753)
    Unsafe library loading vulnerabilities
  * MFSA 2010-72/CVE-2010-3173
    Insecure Diffie-Hellman key exchange
* Wed Sep 15 2010 wr@rosenauer.org
- update to 3.6.10
  * fixing startup topcrash (bmo#594699)
* Thu Aug 26 2010 wr@rosenauer.org
- security update to 3.6.9 (bnc#637303)
  * MFSA 2010-49/CVE-2010-3169
    Miscellaneous memory safety hazards
  * MFSA 2010-50/CVE-2010-2765 (bmo#576447)
    Frameset integer overflow vulnerability
  * MFSA 2010-51/CVE-2010-2767 (bmo#584512)
    Dangling pointer vulnerability using DOM plugin array
  * MFSA 2010-53/CVE-2010-3166 (bmo#579655)
    Heap buffer overflow in nsTextFrameUtils::TransformText
  * MFSA 2010-54/CVE-2010-2760 (bmo#585815)
    Dangling pointer vulnerability in nsTreeSelection
  * MFSA 2010-55/CVE-2010-3168 (bmo#576075)
    XUL tree removal crash and remote code execution
  * MFSA 2010-56/CVE-2010-3167 (bmo#576070)
    Dangling pointer vulnerability in nsTreeContentView
  * MFSA 2010-57/CVE-2010-2766 (bmo#580445)
    Crash and remote code execution in normalizeDocument
  * MFSA 2010-59/CVE-2010-2762 (bmo#584180)
    SJOW creates scope chains ending in outer object
  * MFSA 2010-61/CVE-2010-2768 (bmo#579744)
    UTF-7 XSS by overriding document charset using <object> type
    attribute
  * MFSA 2010-62/CVE-2010-2769 (bmo#520189)
    Copy-and-paste or drag-and-drop into designMode document allows
    XSS
  * MFSA 2010-63/CVE-2010-2764 (bmo#552090)
    Information leak via XMLHttpRequest statusText
* Wed Jul 28 2010 meissner@suse.de
- disable crash reporter for non x86/x86_64 to make it build.
* Sat Jul 24 2010 wr@rosenauer.org
- security update to 3.6.8 (bnc#622506)
  * MFSA 2010-48/CVE-2010-2755 (bmo#575836)
    Dangling pointer crash regression from plugin parameter array
    fix
* Fri Jul 16 2010 wr@rosenauer.org
- security update to 3.6.7 (bnc#622506)
  * MFSA 2010-34/CVE-2010-1211/CVE-2010-1212
    Miscellaneous memory safety hazards
  * MFSA 2010-35/CVE-2010-1208 (bmo#572986)
    DOM attribute cloning remote code execution vulnerability
  * MFSA 2010-36/CVE-2010-1209 (bmo#552110)
    Use-after-free error in NodeIterator
  * MFSA 2010-37/CVE-2010-1214 (bmo#572985)
    Plugin parameter EnsureCachedAttrParamArrays remote code
    execution vulnerability
  * MFSA 2010-38/CVE-2010-1215 (bmo#567069)
    Arbitrary code execution using SJOW and fast native function
  * MFSA 2010-39/CVE-2010-2752 (bmo#574059)
    nsCSSValue::Array index integer overflow
  * MFSA 2010-40/CVE-2010-2753 (bmo#571106)
    nsTreeSelection dangling pointer remote code execution
    vulnerability
  * MFSA 2010-41/CVE-2010-1205 (bmo#570451)
    Remote code execution using malformed PNG image
  * MFSA 2010-42/CVE-2010-1213 (bmo#568148)
    Cross-origin data disclosure via Web Workers and importScripts
  * MFSA 2010-43/CVE-2010-1207 (bmo#571287)
    Same-origin bypass using canvas context
  * MFSA 2010-44/CVE-2010-1210 (bmo#564679)
    Characters mapped to U+FFFD in 8 bit encodings cause subsequent
    character to vanish
  * MFSA 2010-45/CVE-2010-1206/CVE-2010-2751 (bmo#536466,556957)
    Multiple location bar spoofing vulnerabilities
  * MFSA 2010-46/CVE-2010-0654 (bmo#524223)
    Cross-domain data theft using CSS
  * MFSA 2010-47/CVE-2010-2754 (bmo#568564)
    Cross-origin data leakage from script filename in error messages
* Sun Jun 27 2010 wr@rosenauer.org
- update to 3.6.6 release
  * modifies the crash protection feature to increase the amount
    of time that plugins are allowed to be non-responsive before
    being terminated.
* Wed Jun 23 2010 wr@rosenauer.org
- update to final 3.6.4 release (bnc#603356)
  * MFSA 2010-26/CVE-2010-1200/CVE-2010-1201/CVE-2010-1202/
    CVE-2010-1203
    Crashes with evidence of memory corruption (rv:1.9.2.4)
  * MFSA 2010-28/CVE-2010-1198 (bmo#532246)
    Freed object reuse across plugin instances
  * MFSA 2010-29/CVE-2010-1196 (bmo#534666)
    Heap buffer overflow in nsGenericDOMDataNode::SetTextInternal
  * MFSA 2010-30/CVE-2010-1199 (bmo#554255)
    Integer Overflow in XSLT Node Sorting
  * MFSA 2010-31/CVE-2010-1125 (bmo#552255)
    focus() behavior can be used to inject or steal keystrokes
  * MFSA 2010-32/CVE-2010-1197 (bmo#537120)
    Content-Disposition: attachment ignored if
    Content-Type: multipart also present
  * MFSA 2010-33/CVE-2008-5913 (bmo#475585)
    User tracking across sites using Math.random()
* Mon Jun  7 2010 wr@rosenauer.org
- update to 3.6.4(build6)
* Sun Apr 18 2010 wr@rosenauer.org
- security update to 3.6.4 (Lorentz)
  * enable crashreporter also for x86-64
  * Flash runs in a separate process to avoid crashing Firefox
    (ix86 only; x86-64 still uses nspluginwrapper)
* Thu Apr  1 2010 wr@rosenauer.org
- security update to 3.6.3
  * MFSA 2010-25/CVE-2010-1121 (bmo#555109)
    Re-use of freed object due to scope confusion
* Thu Mar 18 2010 wr@rosenauer.org
- security update to version 3.6.2 (bnc#586567)
  * MFSA 2010-08/CVE-2010-1028
    WOFF heap corruption due to integer overflow
  * MFSA 2010-09/CVE-2010-0164 (bmo#547143)
    Deleted frame reuse in multipart/x-mixed-replace image
  * MFSA 2010-10/CVE-2010-0170 (bmo#541530)
    XSS via plugins and unprotected Location object
  * MFSA 2010-11/CVE-2010-0165/CVE-2010-0166/CVE-2010-0167
    Crashes with evidence of memory corruption
  * MFSA 2010-12/CVE-2010-0171 (bmo#531364)
    XSS using addEventListener and setTimeout on a wrapped object
  * MFSA 2010-13/CVE-2010-0168 (bmo#540642)
    Content policy bypass with image preloading
  * MFSA 2010-14/CVE-2010-0169 (bmo#535806)
    Browser chrome defacement via cached XUL stylesheets
  * MFSA 2010-15/CVE-2010-0172 (bmo#537862)
    Asynchronous Auth Prompt attaches to wrong window
  * MFSA 2010-16/CVE-2010-0173/CVE-2010-0174
    Crashes with evidence of memory corruption
  * MFSA 2010-18/CVE-2010-0176 (bmo#538308)
    Dangling pointer vulnerability in nsTreeContentView
  * MFSA 2010-19/CVE-2010-0177 (bmo#538310)
    Dangling pointer vulnerability in nsPluginArray
  * MFSA 2010-20/CVE-2010-0178 (bmo#546909)
    Chrome privilege escalation via forced URL drag and drop
  * MFSA 2010-22/CVE-2009-3555 (bmo#545755)
    Update NSS to support TLS renegotiation indication
  * MFSA 2010-23/CVE-2010-0181 (bmo#452093)
    Image src redirect to mailto: URL opens email editor
  * MFSA 2010-24/CVE-2010-0182 (bmo#490790)
    XMLDocument::load() doesn't check nsIContentPolicy
* Mon Jan 18 2010 wr@rosenauer.org
- update to 3.6rc2 (already named 3.6.0)
- removed obsolete orbit-devel build requirement
* Wed Jan  6 2010 wr@rosenauer.org
- major update to 3.6rc1
* Fri Dec 25 2009 wr@rosenauer.org
- update to version 3.5.7 (bnc#568011)
  * DNS resolution in MakeSN of nsAuthSSPI causing issues for
    proxy servers that support NTLM auth (bmo#535193)
- added missing lockdown preferences (bnc#567131)
* Thu Dec 17 2009 wr@rosenauer.org
- readded firefox-ui-lockdown.patch (bnc#546158)
* Thu Dec  3 2009 wr@rosenauer.org
- security update to version 3.5.6 (bnc#559807)
  * MFSA 2009-65/CVE-2009-3979/CVE-2009-3980/CVE-2009-3982
    Crashes with evidence of memory corruption (rv:1.9.1.6)
  * MFSA 2009-66/CVE-2009-3388 (bmo#504843,bmo#523816)
    Memory safety fixes in liboggplay media library
  * MFSA 2009-67/CVE-2009-3389 (bmo#515882,bmo#504613)
    Integer overflow, crash in libtheora video library
  * MFSA 2009-68/CVE-2009-3983 (bmo#487872)
    NTLM reflection vulnerability
  * MFSA 2009-69/CVE-2009-3984/CVE-2009-3985 (bmo#521461,bmo#514232)
    Location bar spoofing vulnerabilities
  * MFSA 2009-70/VE-2009-3986 (bmo#522430)
    Privilege escalation via chrome window.opener
- fixed firefox-browser-css.patch (bnc#561027)
* Mon Nov 23 2009 wr@rosenauer.org
- rebased patches for fuzz=0
* Thu Nov  5 2009 wr@rosenauer.org
- update to version 3.5.5 (bnc#553172)
* Sat Oct 17 2009 wr@rosenauer.org
- security update to version 3.5.4 (bnc#545277)
  * MFSA 2009-52/CVE-2009-3370 (bmo#511615)
    Form history vulnerable to stealing
  * MFSA 2009-53/CVE-2009-3274 (bmo#514823)
    Local downloaded file tampering
  * MFSA 2009-54/CVE-2009-3371 (bmo#514554)
    Crash with recursive web-worker calls
  * MFSA 2009-55/CVE-2009-3372 (bmo#500644)
    Crash in proxy auto-configuration regexp parsing
  * MFSA 2009-56/CVE-2009-3373 (bmo#511689)
    Heap buffer overflow in GIF color map parser
  * MFSA 2009-57/CVE-2009-3374 (bmo#505988)
    Chrome privilege escalation in XPCVariant::VariantDataToJS()
  * MFSA 2009-59/CVE-2009-1563 (bmo#516396, bmo#516862)
    Heap buffer overflow in string to number conversion
  * MFSA 2009-61/CVE-2009-3375 (bmo#503226)
    Cross-origin data theft through document.getSelection()
  * MFSA 2009-62/CVE-2009-3376 (bmo#511521)
    Download filename spoofing with RTL override
  * MFSA 2009-63/CVE-2009-3377/CVE-2009-3379/CVE-2009-3378
    Upgrade media libraries to fix memory safety bugs
  * MFSA 2009-64/CVE-2009-3380/CVE-2009-3381/CVE-2009-3383
    Crashes with evidence of memory corruption
- removed upstreamed patch
  * firefox-bug506901.patch
* Wed Oct  7 2009 llunak@novell.com
- fix KDE button order in one more place (bnc#170055)
* Fri Oct  2 2009 wr@rosenauer.org
- improve UI colors to be usable with dark themes at all
  (firefox-browser-css.patch) (bnc#503351)
- extend list of supported architectures as ABI identifier
  (mozilla-abi.patch) (bnc#543460)
* Sun Sep 13 2009 wr@rosenauer.org
- added KDE integration patch from llunak@novell.com
  (firefox-kde.patch)
  * support for knotify, making -kde4-addon obsolete
  * KDE-specific support functional (bnc#170055)
- do not build libnkgnomevfs (bmo#512671) (firefox-no-gnomevfs)
* Thu Sep 10 2009 wr@rosenauer.org
- security update to version 3.5.3 (bnc#534458)
  * MFSA 2009-47/CVE-2009-3069/CVE-2009-3070/CVE-2009-3071/
    CVE-2009-3072/CVE-2009-3073/CVE-2009-3074/CVE-2009-3075
    Crashes with evidence of memory corruption
  * MFSA 2009-49/CVE-2009-3077 (bmo#506871)
    TreeColumns dangling pointer vulnerability
  * MFSA 2009-50/CVE-2009-3078 (bmo#453827)
    Location bar spoofing via tall line-height Unicode characters
  * MFSA 2009-51/CVE-2009-3079 (bmo#454363)
    Chrome privilege escalation with FeedWriter
* Wed Aug 19 2009 wr@rosenauer.org
- renamed patch firefox-contextmenu-gnome to firefox-cross-desktop
  as it contains more tweaks to handle non-Gnome environments and
  especially KDE integration:
  * added the ability to set the KDE default browser
    (still part of bnc#170055)
* Fri Aug  7 2009 wr@rosenauer.org
- split -translations package into -common and -other
  (bnc#529180)
- remove "set as background" from context menu if not running in
  Gnome (part of bnc#170055)
* Fri Jul 31 2009 wr@rosenauer.org
- security update to version 3.5.2
  * MFSA 2009-38/CVE-2009-2470 (bmo#459524)
    Data corruption with SOCKS5 reply containing DNS name longer
    than 15 characters
  * MFSA 2009-44/CVE-2009-2654 (bmo#451898)
    Location bar and SSL indicator spoofing via window.open() on
    invalid URL
  * MFSA 2009-45
    Crashes with evidence of memory corruption
  * MFSA 2009-46 (bmo#498897)
    Chrome privilege escalation due to incorrectly cached wrapper
  * various other stability fixes
- export MOZ_APP_LAUNCHER in the startscript (bmo#453689)
* Tue Jul 28 2009 wr@rosenauer.org
- fixed %%exclude usage
- fixed preferences' advanced pane for fresh profiles (bmo#506901)
* Wed Jul 15 2009 wr@rosenauer.org
- security update to version 3.5.1
  * MFSA 2009-41
    Corrupt JIT state after deep return from native function
* Mon Jul  6 2009 wr@rosenauer.org
- added mozilla-linkorder.patch to fix build with --as-needed
* Tue Jun 30 2009 wr@rosenauer.org
- update to final version 3.5 (20090623)
* Tue Jun 23 2009 wr@rosenauer.org
- fixed build by linking to a real file
* Thu Jun 18 2009 wr@rosenauer.org
- update to version 3.5rc2 (20090617)
- BuildRequire mozilla-xulrunner191 = 1.9.1.0
* Sat Jun  6 2009 wr@rosenauer.org
- update to version 3.5b99 (20090604)
- BuildRequire mozilla-xulrunner191 = 1.9.1b99
* Wed May 27 2009 wr@rosenauer.org
- fixed typos in improved xulrunner dependencies
* Mon May 11 2009 wr@rosenauer.org
- use non-localized Downloads folder (bnc#501724)
* Mon May  4 2009 wr@rosenauer.org
- update to new major version 3.5b4
  * based on Gecko 1.9.1 (mozilla-xulrunner191)
  * Private Browsing Mode
  * TraceMonkey JavaScript engine
  * Geolocation support
  * native JSON and web worker threads support
  * speculative parsing for faster content rendering
  * Some HTML5 support
- updated firefox.schemas
- improved firefox-no-update.patch
* Tue Apr 28 2009 wr@rosenauer.org
- security update to 3.0.10
  * MFSA 2009-23/CVE-2009-1313 (bmo#489647)
    Crash in nsTextFrame::ClearTextRun()
* Thu Apr 16 2009 wr@rosenauer.org
- security update to 3.0.9 (bnc#495473)
  * MFSA 2009-14/CVE-2009-1302/CVE-2009-1303/CVE-2009-1304/CVE-2009-1305
    Crashes with evidence of memory corruption (rv:1.9.0.9)
  * MFSA 2009-15/CVE-2009-0652 (bmo#479336)
    URL spoofing with box drawing character
  * MFSA 2009-16/CVE-2009-1306 (bmo#474536)
    jar: scheme ignores the content-disposition: header on the
    inner URI
  * MFSA 2009-17/CVE-2009-1307 (bmo#481342)
    Same-origin violations when Adobe Flash loaded via
    view-source: scheme
  * MFSA 2009-18/CVE-2009-1308 (bmo#481558)
    XSS hazard using third-party stylesheets and XBL bindings
  * MFSA 2009-19/CVE-2009-1309 (bmo#482206,478433)
    Same-origin violations in XMLHttpRequest and
    XPCNativeWrapper.toString
  * MFSA 2009-20/CVE-2009-1310 (bmo#483086)
    Malicious search plugins can inject code into arbitrary sites
  * MFSA 2009-21/CVE-2009-1311 (bmo#471962)
    POST data sent to wrong site when saving web page with
    embedded frame
  * MFSA 2009-22/CVE-2009-1312 (bmo#475636)
    Firefox allows Refresh header to redirect to javascript: URIs
* Fri Mar 27 2009 wr@rosenauer.org
- security update to 1.9.0.8 (bnc#488955,489411)
  * MFSA 2009-12/CVE-2009-1169 (bmo#460090,485217)
    Crash and remote code execution in XSL transformation
  * MFSA 2009-13/CVE-2009-1044 (bmo#484320)
    Arbitrary code execution via XUL tree moveToEdgeShift
- allow RPM provides for stuff besides shared libraries
  (e.g. mime-types)
* Sun Mar  1 2009 wr@rosenauer.org
- security update to 3.0.7 (bnc#478625)
  * MFSA 2009-07 - Crashes with evidence of memory corruption
    CVE-2009-0771 - Layout Engine Crashes
    CVE-2009-0772 - Layout Engine Crashes
    CVE-2009-0773 - crashes in the JavaScript engine
    CVE-2009-0774 - Layout Engine Crashes
  * MFSA 2009-08/CVE-2009-0775 - (bmo#474456)
    Mozilla Firefox XUL Linked Clones Double Free Vulnerability
  * MFSA 2009-09/CVE-2009-0776 (bmo#414540)
    XML data theft via RDFXMLDataSource and cross-domain redirect
  * MFSA 2009-10/CVE-2009-0040 (bmo#478901)
    Upgrade PNG library to fix memory safety hazards
  * MFSA 2009-11/CVE-2009-0777 (bmo#452979)
    URL spoofing with invisible control characters
* Wed Feb  4 2009 hfiguiere@suse.de
- Review and approve changes.
* Wed Jan 28 2009 wr@rosenauer.org
- security update to 3.0.6 (bnc#470074)
  * MFSA 2009-06/CVE-2009-0358: Directives to not cache pages ignored
    (bmo#441751)
  * MFSA 2009-05/CVE-2009-0357: XMLHttpRequest allows reading
    HTTPOnly cookies (bmo#380418)
  * MFSA 2009-04/CVE-2009-0356: Chrome privilege escalation via
    local .desktop files (bmo#460425)
  * MFSA 2009-03/CVE-2009-0355: Local file stealing with SessionStore
    (bmo#466937)
  * MFSA 2009-02/CVE-2009-0354: XSS using a chrome XBL method
    and window.eval (bmo#468581)
  * MFSA 2009-01/CVE-2009-0352 - CVE-2009-0353: Crashes with
    evidence of memory corruption (rv:1.9.0.6) (bmo#452913,
    bmo#449006, bmo#331088, bmo#401042, bmo#416461, bmo#422283,
    bmo#422301, bmo#431705, bmo#437142, bmo#421839, bmo#420697,
    bmo#461027)
  * (non security) added lv locale
* Thu Jan 22 2009 hfiguiere@suse.de
- Fix the wrapper script for PowerPC 64-bits (bnc#464753)
* Wed Dec 17 2008 hfiguiere@suse.de
- Review and approve changes.
* Mon Dec 15 2008 wr@rosenauer.org
- security update to 1.9.0.5 (bnc#455804)
  for details
  http://www.mozilla.org/security/known-vulnerabilities/firefox30.html
  * removed aboutRights workaround again
  * added et locale
* Tue Nov 25 2008 hfiguiere@suse.de
- Review and approve changes.
* Sat Nov 22 2008 wr@rosenauer.org
- replace license agreement with about:rights toolbar
  (backported from upcoming FF 3.0.5) (bnc#436054, bmo#456439)
  (it's always displayed in en-US)
* Fri Nov 21 2008 hfiguiere@suse.de
- Update firefox-lockdown-ui.patch
  * Print Setup is now properly locked down. bnc#431028
  * Bookmark editing it now properly locked down. bnc#439335
  * Bookmars are properly hidden.
  * History is properly locked down. bnc#439343
  * Make sure the search bar is not put back when resetting the
    toolbar. bnc#439358
* Fri Nov 21 2008 maw@suse.de
- Review and approve changes.
* Thu Nov 13 2008 wr@rosenauer.org
- lockdown cleanup
  * removed gecko-lockdown.patch from Firefox (it's in xulrunner)
  * stripped out some toolkit stuff from firefox-ui-lockdown
  * added extra default preferences for lockdown
* Wed Nov 12 2008 maw@suse.de
- Review and approve changes.
* Tue Nov 11 2008 wr@rosenauer.org
- update to security/maintenance release 3.0.4 (bnc#439841)
  * support additional locales (bg, cy, eo, oc)
- removed obsolete configure option (enable-gconf)
* Fri Nov  7 2008 maw@suse.de
- Review and approve changes.
* Tue Nov  4 2008 wr@rosenauer.org
- moved gconf schema into branding packages (bnc#441646)
* Tue Oct 28 2008 hfiguiere@suse.de
- Fix missing %%endif (for fix for bnc#434283)
* Mon Oct 27 2008 hfiguiere@suse.de
- Add disable_show_passwords to firefox.schemas. (FATE #301534)
* Mon Oct 27 2008 wr@rosenauer.org
- make biarch dependencies work correctly (bnc#434283)
* Thu Oct 23 2008 hfiguiere@suse.de
- Added firefox-ui-lockdown.patch and gecko-lockdown.patch
  * Lockdown: FATE#302023, FATE#302024
* Mon Oct  6 2008 sbrabec@suse.cz
- Conflict with other branding providers (FATE#304881).
* Mon Sep 29 2008 maw@suse.de
- Review and approve changes.
* Mon Sep 29 2008 maw@suse.de
- Remove a reference to a stale patch.
* Sun Sep 28 2008 wr@rosenauer.org
- update to regression fix release 3.0.3
  * Fixed a problem where users were unable to retrieve saved
    passwords or save new passwords (bmo#454708, bnc#429179#c20,
    CVE-2008-4063, CVE-2008-4064, CVE-2008-3836, andCVE-2008-4070)
* Thu Sep 25 2008 maw@suse.de
- Review and approve changes.
* Mon Sep 15 2008 wr@rosenauer.org
- update to security/maintenance release 3.0.2 (bnc#429179)
- removed unused files from sources
- fix more rpmlint complaints and provide a config file to filter
  false positives
- disable Gnome crashreporter as it has no value
- brought man-page up to date for the firefox stub
  (removing firefox-bin reference)
- en-US locale not longer packaged in translations subpackage
* Fri Aug 15 2008 maw@novell.com
- Review and approve changes.
* Mon Aug  4 2008 wr@rosenauer.org
- Tweak branding split
* Tue Jul 29 2008 vuntz@novell.com
- Create branding package (bnc#390752):
  + search-addons.tar.bz2, bookmarks.html.suse and
    firefox-suse-default-prefs.js will be moved to
    MozillaFirefox-branding-openSUSE
  + create a MozillaFirefox-branding-upstream package
* Mon Jul 28 2008 mauro@suse.de
- Update to stability/security release 3.0.1 (bnc#407573)
  (thanks, Wolfgang)
  + MFSA 2008-36  Crash with malformed GIF file on Mac OS X
  + MFSA 2008-35 Command-line URLs launch multiple tabs when
    Firefox not running
  + MFSA 2008-34 Remote code execution by overflowing CSS reference counter
- Set browser.shell.checkDefaultBrowser to true (bnc#404119)
* Tue Jun 17 2008 maw@suse.de
- Merge changes from the build service (thanks, Wolfgang)
  (bnc#400001 and SWAMP#18164).
* Tue Jun 17 2008 wr@rosenauer.org
- update to version 3.0
- fixed double entry in bookmarks for www.opensuse.org (bnc#396980
* Thu May 15 2008 aj@suse.de
- Add Planet SUSE, forums.o.o and How to participate to default
  URLs.
* Fri May  2 2008 maw@suse.de
- network.protocol-handler.app.* prefs are no longer supported;
  remove references to them from firefox-suse-default-prefs.js
  (bnc#383697).
* Wed Apr  2 2008 maw@suse.de
- Update to Firefox 3.0b5 (2.9.95) (thanks, Wolfgang).
* Wed Mar 26 2008 maw@suse.de
- Merge changes from the build service (thanks, Wolfgang)
- Update to the fourth Firefox 3.0 Beta (2.9.94):
  + Based upon the Gecko 1.9 Web rendering platform, which improves
    performance, stability, and rendering correctness; it also
    boasts a considerable simplification in its code
  + Security improvements:
  * One-click site info
  * Malware Protection
  * New Web Forgery Protection page
  * New SSL error pages
  * Add-ons and Plugin version check
  * Secure add-on updates
  * Effective top-level domain (eTLD) service to better restrict
    cookies and other restricted content to a single domain
  * Better protection against cross-site JSON data leaks
  + Usability improvements:
  * Easier password management
  * Simplified add-on installation
  * New Download Manager
  * Resumable downloading
  * Full page zoom
  * Podcasts and Videocasts can be associated with your media
    playback tools
  * Tab scrolling and quickmenu
  * Save what you were doing: Firefox will prompt users to save
    tabs on exit
  * Optimized Open in Tabs behavior
  * Location and Search bar size can now be customized with a
    simple resizer item
  * Text selection improvements
  * Find toolbar
  * Improved integration with Linux: Firefox's default icons,
    buttons, and menu styles now use the native GTK theme
  + Personalization improvements:
  * Star button: quickly add bookmarks from the location bar
    with a single click; a second click lets you file and tag them
  * Tags: associate keywords with your bookmarks to sort them
    by topic
  * Location bar & auto-complete
  * Smart Bookmarks Folder
  * Places Organizer: view, organize and search through all
    of your bookmarks, tags, and browsing history with multiple
    views and smart folders to store your frequent searches
  * Web-based protocol handlers
  * Download & Install Add-ons
  * Easy to use Download Actions
  + Improved platform for web developers:
  * New graphics and font handling: new graphics and text
    rendering architectures in Gecko 1.9 provides rendering
    improvements in CSS, SVG as well as improved display of
    fonts with ligatures and complex scripts
  * Color management: (set gfx.color_management.enabled on
    in about:config and restart the browser to enable.);
    Firefox can now adjust images with embedded color profiles
  * Offline support: enables web applications to provide
    offline functionality (website authors must add support
    for offline browsing to their site for this feature
    to be available to users)
  + Improved performance:
  * Speed: improvements to the JavaScript engine as well as
    profile guided optimizations have resulted in significant
    improvements in performance; compared to Firefox 2,
    web applications like Google Mail and Zoho Office run
    twice as fast in Firefox 3 Beta 4, and the popular
    SunSpider test from Apple shows improvements over
    previous releases
  * Memory usage: Several new technologies work together to
    reduce the amount of memory used by Firefox 3 Beta 4
    over a web browsing session;  memory cycles are broken
    and collected by an automated cycle collector, a new
    memory allocator reduces fragmentation, hundreds of leaks
    have been fixed, and caching strategies have been tuned
  * Reliability: A user's bookmarks, history, cookies, and
    preferences are now stored in a transactionally secure
    database format which will prevent data loss even if their
    system crashes
- This version depends upon the mozilla-xulrunner190 package
- Drop various stale packages, respin several that have been
  kept around, and add a few new ones.
* Mon Feb 11 2008 maw@suse.de
- Security update to version 2.0.0.12 (bnc#354469):
  + MFSA 2008-11/CVE-2008-0594 Web forgery overwrite with div
    overlay
  + MFSA 2008-10/CVE-2008-0593 URL token stealing via stylesheet
    redirect
  + MFSA 2008-09/CVE-2008-0592 Mishandling of locally-saved plain
    text files
  + MFSA 2008-08/CVE-2008-0591 File action dialog tampering
  + MFSA 2008-06/CVE-2008-0419 Web browsing history and forward
    navigation stealing
  + MFSA 2008-05/CVE-2008-0418 Directory traversal via chrome: URI
  + MFSA 2008-04/CVE-2008-0417 Stored password corruption
  + MFSA 2008-03/CVE-2008-0415 Privilege escalation, XSS, Remote
    Code Execution
  + MFSA 2008-02/CVE-2008-0414 Multiple file input focus stealing
    vulnerabilities
  + MFSA 2008-01/CVE-2008-0412 Crashes with evidence of memory
    corruption (rv:1.8.1.12)
- Reference libaoss.so in start script (bnc#117079)
- Remove mozilla-canvas-1.8.1.10.patch, as it has been upstreamed
- Update firefox-ui-lockdown.patch (FATE#301534, FATE#302023, and
  FATE#302024)
- Add application/x-xpinstall mime type to MozillaFirefox.desktop
- Add MozillaFirefox.xml to bind .xpi to application/x-xpinstall
  in desktop.
* Thu Jan 17 2008 maw@suse.de
- Add mozilla-maxpathlen.patch (#354150 and bmo #412610).
* Fri Dec 21 2007 maw@suse.de
- Add firefox-348446-empty-lists.patch (bnc#348446).
* Wed Dec  5 2007 maw@suse.de
- Respin proxy-dev.patch (bnc#340678) -- thanks, Anders!
* Tue Nov 27 2007 maw@suse.de
- Security update to version 2.0.0.10 (#341905, #341591):
  + MFSA 2007-39  Referer-spoofing via window.location race condition
  + MFSA 2007-38 Memory corruption vulnerabilities (rv:1.8.1.10)
  + MFSA 2007-37 jar: URI scheme XSS hazard
  + Fixes for regressions introduced in 2.0.0.8
  + Updated dbus.patch, startup.patch, misc.dif, and configure.patch
- Add mozilla-gcc4.3-fixes.patch
- Add mozilla-canvas-1.8.1.10.patch (#341591#c10).
* Mon Nov 26 2007 maw@suse.de
- Build with -ftree-vrp -fwrapv, per advice in #342603#c17.
* Tue Nov 13 2007 maw@suse.de
- Add firefox-gcc4.3-fixes.patch.
* Fri Oct 19 2007 maw@suse.de
- Security update to version 2.0.0.8 (#332512) (thanks, Wolfgang)
  * MFSA 2007-29 Crashes with evidence of memory corruption
  * MFSA 2007-30 onUnload Tailgating
  * MFSA 2007-31 Digest authentication request splitting
  * MFSA 2007-32 File input focus stealing vulnerability
  * MFSA 2007-33 XUL pages can hide the window titlebar
  * MFSA 2007-34 Possible file stealing through sftp protocol
  * MFSA 2007-35 XPCNativeWraper pollution using Script object
  complete advisories on
  http://www.mozilla.org/projects/security/known-vulnerabilities.html
* Sun Sep 23 2007 maw@suse.de
- Don't explicitly require libaoss.so (#326751).
* Fri Sep 14 2007 maw@suse.de
- Update the Novell Support search plugin in search-addons.tar.bz2
  (#297261)
- Set the browser.tabs.loadFolderAndReplace preference to false
  by default (#230759).
* Wed Sep 12 2007 dmueller@suse.de
- fix hardlinks accross partitions
* Thu Sep  6 2007 maw@suse.de
- Add http://software.opensuse.org/search?baseproject=openSUSE:10.3
  to the default bookmarks (#308223).
* Mon Sep  3 2007 ro@suse.de
- move last change a bit further in specfile
* Fri Aug 31 2007 maw@suse.de
- Mark a .png file as nonexecutable.
* Tue Aug 28 2007 maw@suse.de
- Minor .spec update (#305193)
  + Remove two obsolete patches
  + Correct releasedate
  + Include only the officially supported locales.
* Wed Aug 22 2007 maw@suse.de
- Merge changes from the build service (thanks, Wolfgang):
  + Provide locale dependency information (#302288)
  + Add x11-session.patch, supporting X11 session management
    (#227047)
  + Update to version 2.0.0.6
  * MFSA 2007-26  Privilege escalation through chrome-loaded
    about:blank windows
  * MFSA 2007-27  Unescaped URIs passed to external programs
    (only relevant on Windows)
- Use %%fdupes.
* Tue Aug 21 2007 aj@suse.de
- Adjust bookmarks: Add news.opensuse.org, use new software.o.o
  page.
* Thu Aug 16 2007 mauro@suse.de 
- Revert previous change.
* Tue Aug 14 2007 mauro@suse.de
- Added support for ymp in the mimetypes.rdf
- Added OneClickInstallUrlHandler for handing the actual call from firefox.
- Fixes bnc #295677
* Mon Jul 23 2007 maw@suse.de
- Security update to version 2.0.0.5 (#288115) which has fixes for:
  MFSA 2007-18
    CVE-2007-3734 - Browser flaws
    CVE-2007-3735 - Javascript flaws
  MFSA 2007-19
    CVE-2007-3736
  MFSA 2007-20
    CVE-2007-3089
  MFSA 2007-21
    CVE-2007-3737
  MFSA 2007-22
    CVE-2007-3285
  MFSA 2007-23
    CVE-2007-3670
  MFSA 2007-24
    CVE-2007-3656
  MFSA 2007-25
    CVE-2007-3738
* Thu Jun 21 2007 adrian@suse.de
- fix changelog entry order
* Mon Jun 18 2007 maw@suse.de
- Use mozilla.sh.in from the build service (#230681).
* Tue Jun  5 2007 sbrabec@suse.cz
- Removed invalid desktop category "Application" (#254654).
* Tue Jun  5 2007 maw@suse.de
- Security update to version 2.0.0.4
- Refresh configure.patch, startup.patch, and visibility.patch
- Now use l10n-%%{version}.tar.bz2 instead of l10n.tar.bz2.
* Mon Apr 30 2007 ro@suse.de
- added unzip to BuildRequires
* Wed Apr 18 2007 mfabian@suse.de
- add Japanese to the languages which get PANGO enabled in the
  start script to support the Japanese combining characters
  U+3099 U+309A (see bugzilla #262718 comment #29).
* Mon Mar 12 2007 maw@suse.de
- Package gconf stuff.
* Wed Feb 21 2007 maw@suse.de
- Security update to 2.0.0.2 (#244923), which covers:
  + mfsa2007-01
  * CVE-2007-0775 - layout engine crashes
  * CVE-2007-0776 - SVG
  * CVE-2007-0777 - javascript engine corruption
  + mfsa2007-02
  * CVE-2007-0995 - Invalid trailing characters in HTML tag attributes
  * CVE-2007-0996 - Child frame character set inheritance
  * CVE-2006-6077 - Injected password forms
  + mfsa2007-02
  + mfsa2007-03
  * CVE-2007-0078
  + mfsa2007-04
  * CVE-2007-0079
  + mfsa2007-05
  * CVE-2007-0780
  * CVE-2007-0800
  + mfsa2007-06
  * CVE-2007-0008 - client flaw
  * CVE-2007-0009 - server flaw
  + mfsa2007-07
  * CVE-2007-0981
- Updates mozilla.sh.in (#230681)
- Fixes #232209
- Updates the man page (#243037)
- Properly propagates exit codes (#241492)
- Adds em-356370.patch (#217374)
* Thu Jan 25 2007 maw@suse.de
- Fixup the Gnome paths, keeping in closer sync with the
  buildservice.
* Thu Jan 18 2007 maw@suse.de
- Gnome is now in /usr, so remove references to /opt/gnome
- Install firefox.png with the executable bit not set.
* Wed Jan 10 2007 meissner@suse.de
- readd MozillaFirebird provides (was incorrect in removing it).
* Mon Jan  8 2007 meissner@suse.de
- Do not provide MozillaFirebird, just obsolete it.
* Fri Dec  1 2006 maw@suse.de
- Update gecko-lockdown.patch (#220616).
* Thu Nov 30 2006 maw@suse.de
- Update firefox-suse-default-prefs.js, adding
  'pref("browser.backspace_action", 2);' (#217374)
* Thu Nov 30 2006 aj@suse.de
- Fix last change (#224431).
* Wed Nov 29 2006 aj@suse.de
- Change download bookmark (#224431).
- Rename bookmark folder to openSUSE.
* Tue Nov 28 2006 aj@suse.de
- Sync from Buildservice with following critical fixes (thanks
  Wolfgang Rosenauer!):
  * fixed system-proxies.patch to actually work (#223881).
  * Rearrange Bookmarks to pass trademark review.
* Mon Nov 27 2006 aj@suse.de
- Fix tango theme (#223796).
* Mon Nov 27 2006 aj@suse.de
- Use www.opensuse.org as home page.
* Sun Nov 12 2006 aj@suse.de
- Set novell.com as home page.
- Update from BuildService (thanks Wolfgang!):
  - fixed crash in htmlparser (#217257, bmo #358797)
  - added gconf2 as PreReq (#212505)
  - added 32bit libaoss.so as requirement (#216266)
  - Removed SUSE searchplugin (Portal not available anymore)
    (#216054)
  - Removed obsolete xul-picker.patch and system-nspr.patch
  - Fixed building on 10.1 and 10.0 (dbus)
  - Removed obsolete throbber preference
* Thu Nov  9 2006 jhargadon@suse.de
- updated tango theme
* Sun Oct 29 2006 aj@suse.de
- Another fix for 214125, patch by Wolfgang Rosenauer.
* Thu Oct 26 2006 aj@suse.de
- Fix gcc warnings about undefined operations, patch by
  Robert O'Callahan.
- Update system-proxies.patch to fix error box (214125), patch by
  Robert O'Callahan.
* Mon Oct 23 2006 aj@suse.de
- Update to current CVS version of 2.0.
- Use www.opensuse.org as default home page for now (#203547).
* Sat Oct 21 2006 aj@suse.de
- Disable non-working plasticfox and tango themes.
* Fri Oct 20 2006 aj@suse.de
- Fix building of locales.
* Fri Oct 20 2006 mkoenig@suse.de
- update to version 2.0rc3:
  * New features: Visual Refresh, Built-in phishing protection,
    Enhanced search capabilities, Improved tabbed browsing,
    Resuming your browsing session, Previewing and subscribing
    to Web feeds, Inline spell checking, Live Titles,
    Improved Add-ons manager, JavaScript 1.7, Extended search
    plugin format, Updates to the extension system,
    Client-side session and persistent storage, SVG text
* Tue Oct 17 2006 meissner@suse.de
- disabled debugging.
* Tue Sep 12 2006 stark@suse.de
- security update to version 1.5.0.7
* Mon Aug 21 2006 stark@suse.de
- added greasemonkey helper change (#199920)
- fixed packager.mk for new make version
* Fri Aug 11 2006 stark@suse.de
- fixed crash in dbus component (patch by thoenig #197928)
- use external adresses for PAC configuration (#196506)
* Mon Aug  7 2006 stark@suse.de
- added symlink for Firefox 1.0.x compatibility
* Sat Jul 29 2006 stark@suse.de
- update to regression release 1.5.0.6 (#195043)
* Thu Jul 27 2006 stark@suse.de
- security update to version 1.5.0.5 (#195043)
  * observer-lock.patch integrated now
- fixed leak in JS' liveconnect (#186066)
- fixed desktop file for old distributions
  (StartupNotify=false)
* Thu Jun 29 2006 stark@suse.de
- fixed printing crash if the last used printer is not available
  anymore (#187013)
* Fri Jun 16 2006 stark@suse.de
- added 48x48 icon (#185777)
* Mon Jun 12 2006 stark@suse.de
- fix overwrite confirmation for GTK filesaver (#179531)
- get network.negotiate-auth.trusted-uris and
  network.negotiate-auth.delegation-uris from gconf if
  system-settings are enabled (#184489)
* Thu Jun  1 2006 stark@suse.de
- update to security/stability release 1.5.0.4 (#179011)
- moved locale-global prefs to browserconfig.properties (#177881)
* Tue May 23 2006 stark@suse.de
- complete implementation of startup-notification (#115417)
  (including autoconf and remote support)
- different home-pages for SLE10 and SL (#177881)
* Tue May 16 2006 stark@suse.de
- fixed potential deadlock in nsObserverList::RemoveObserver
  (#173986, bmo #338069)
- base startup notification on libstartup-notification (#115417)
* Thu May 11 2006 stark@suse.de
- save printer settings properly (#174082, bmo #324072)
- added startup notification support for showing load activity
  in Gnome and to avoid focus stealing prevention (#115417)
- added StartupNotify=true to desktop file (#115417)
- provide legacy symlink for NLD9 update compatibility (#173138)
- fixed system-proxies patch to avoid unwanted wpad requests
  (#171743, #167613)
* Mon May  8 2006 stark@suse.de
- preconfigure the theme according to the used desktop (#151163)
* Thu Apr 27 2006 stark@suse.de
- last minute change for 1.5.0.3
* Wed Apr 26 2006 stark@suse.de
- security update to 1.5.0.3
- fix for typo in postscript.patch
* Tue Apr 25 2006 stark@suse.de
- fixed iframe crash (#169039, bmo #334515)
- fixed img tag misuse (#168710, bmo #334341)
* Mon Apr 24 2006 stark@suse.de
- improved postscript output (bmo #334485)
- changed defaults for printer properties (#6534)
- overwrite gnome-vfs' file protocol by providing "desktop-launch"
  (#131501)
- get available paper sizes from CUPS (#65482)
- replaced/removed complicated gconfd reload in %%post (#167989)
- fixed memory leak in clipboard caching (bmo #289897)
* Tue Apr 11 2006 stark@suse.de
- added (optional) plastikfox theme (#151163)
- get some more security related patches (#148876)
- finally fixed the default proxy configuration by adding a new
  UI option (#132398)
* Mon Apr  3 2006 stark@suse.de
- fixed keyword fixup patch (#162532)
* Tue Mar 28 2006 stark@suse.de
- don't use keyword fixup for pasted text (#160034, bmo #331522)
* Mon Mar 20 2006 stark@suse.de
- added Tango theme
- fixed reading proxies from gconf (#132398)
* Sun Mar 12 2006 stark@suse.de
- tweaked bookmarks (fixed URLs)
- added Khmer (km-*) to pango locales (#157397)
* Sat Mar  4 2006 stark@suse.de
- fixed crash with multipart JPEGs (bmo #328684) (#140416)
- got latest security fixes from upstream (#148876)
* Wed Feb 22 2006 stark@suse.de
- fixed plugin loading when launched from Thunderbird (#151614)
- merged dbus reconnection patch (#150042)
- default to autodetect proxy (network.proxy.type=4) (#151811)
- added GTK category to desktop file
* Tue Feb 14 2006 stark@suse.de
- modified lockdown patches (#67281, #67282)
- applied set of security patches (#148876)
  bmo bugs: 282105, 307989, 315625, 320459, 323634, 325403, 325947
* Tue Feb  7 2006 stark@suse.de
- fixed disabling of Pango (#148788)
* Thu Feb  2 2006 stark@suse.de
- define gssapi lib explicitely (#147670)
- use only official Firefox-Icon
- changed home-download patch
* Sun Jan 29 2006 stark@suse.de
- throbber URL is default again
- removed firefox-showpass patch
- removed additional CA certs from builtin NSS
* Fri Jan 27 2006 stark@suse.de
- got some l10n changes from 1.8.0 branch
* Fri Jan 27 2006 stark@suse.de
- final 1.5.0.1 version
- make it possible to choose $HOME as download directory
  (#144894, bmo #300856)
* Wed Jan 25 2006 mls@suse.de
- converted neededforbuild to BuildRequires
* Sun Jan 22 2006 stark@suse.de
- disable Pango if MOZ_ENABLE_PANGO is not set
  and no typical language which needs Pango is used (#143428)
* Wed Jan 18 2006 stark@suse.de
- fixed DumpStackToFile() for glibc 2.4
- added default (font) settings
* Thu Jan 12 2006 stark@suse.de
- update to 1.5.0.1pre (20060111)
- updated man-page
- fixed hovered tab close button
- only Requires mozilla-nspr instead of PreReq since
  there is no postinstall registration necessary anymore
- use system NSS from CODE10 on
- use -fstack-protector where available
- changed unixproxy component to work on older distributions
* Mon Jan  2 2006 stark@suse.de
- added unixproxy component written by Robert O'Callahan (#132398)
  (bmo #66057)
- added official translations
- preload libaoss for plugin sound (#117079)
* Wed Dec 28 2005 stark@suse.de
- get some patches from 1.8.0 branch
- readded modification to gconf-backend (bmo #321315)
- readded lockdown stuff
- enable additional extension install directory (#120329)
  (/usr/lib/browser-extensions/firefox)
- added patch to make the XUL filechooser optional
  (MOZ_XUL_PICKER)
* Wed Dec 14 2005 stark@suse.de
- fixed patch for parsing -remote parameter
- removed default-plugin patch (not needed anymore)
* Fri Dec  9 2005 stark@suse.de
- fix to ignore X composite extension (#135373)
- fixed parsing of -remote parameters (#134396)
- activated locales as released
* Tue Nov 29 2005 stark@suse.de
- update to 1.5 (20051128)
- don't override startup URL when changing Gecko versions (#135314)
- added patch for GTK2 handling (#134831)
- readded add-plugins stuff for compatibility
* Fri Nov 18 2005 stark@suse.de
- update to 1.5rc3 (20051117)
* Mon Oct 31 2005 stark@suse.de
- updated l10n archive (20051030)
- fixed postinstall script to copy plugin links instead of files
* Fri Oct 28 2005 stark@suse.de
- update to 1.5rc1 (20051027)
- fixed profile locking on FAT partitions (bmo #313360)
- introduced an rpath again
* Wed Oct 19 2005 stark@suse.de
- update to snapshot 1.5 (20051019)
- moved installation to /usr/%%{_lib}/firefox
- added dbus component to be able to get network status from
  NetworkManager (bmo #312793)
- remove all update UI for application
- removed diable-gconf (no registration at build time anymore)
- removed rebuild-databases.sh (no system registration anymore)
- open links in new windows (#128087)
* Thu Oct  6 2005 stark@suse.de
- update to Firefox 1.5b2 (20051005)
- added supported translations
* Sat Oct  1 2005 stark@suse.de
- update to Firefox 1.5b1 (20050930) RPM version 1.4.1
- removed rebuild-databases.sh calls
- removed add-plugins.sh calls and corresponding triggers
- enabled SVG and Canvas support
- fixed gconf urlhandler registration
* Tue Sep 20 2005 stark@suse.de
- security update to 1.0.7 (#117619)
  * MFSA 2005-57: IDN heap overrun using soft-hyphens (bmo #307259)
    (enabled IDN pref again)
  * MFSA 2005-58:
    CAN-2005-2701 Heap overrun in XBM image processing
    CAN-2005-2702 Crash on "zero-width non-joiner" sequence
    CAN-2005-2703 XMLHttpRequest header spoofing
    CAN-2005-2704 Object spoofing using XBL <implements>
    CAN-2005-2705 JavaScript integer overflow
    CAN-2005-2706 Privilege escalation using about: scheme
    CAN-2005-2707 Chrome window spoofing
    Regression fixes
- register beagle extension if it gets installed (#116787)
* Tue Sep 13 2005 aj@suse.de
- Change SUSE bookmarks.
* Sun Sep 11 2005 stark@suse.de
- disable IDN per default (#116070)
- unlocalize bookmarks (#114279)
* Thu Sep  8 2005 stark@suse.de
- fixed some filemodes (#114849)
* Sat Sep  3 2005 stark@suse.de
- fixed gconf-backend patch to be able to use
  system prefs (#114054)
* Thu Sep  1 2005 stark@suse.de
- changed default font to sans-serif (#114464)
- removed de-de parts of the bookmark-links (#114279)
* Mon Aug 22 2005 stark@suse.de
- install gconf schema for lockdown also on non-NLD
- added backports (firefox-backports.patch)
  * gtk_im_context_set_cursor_location() is not used (bmo #281339)
  * fixed crash in imgCacheValidator::OnStartRequest()
    (bmo #293307)
- workaround for linking with pangoxft and pangox
  (broken by gtk 2.8 update) (#105764)
- remove extensions on deinstallation
- include dragonegg (kparts) plugin (#105468)
* Thu Aug 18 2005 stark@suse.de
- fixed regression in profile locking change (bmo #303633)
- added rtsp handler to global config (#104434)
- don't blacklist help: protocol (bmo #304833)
- fixed Gdk-WARNING at startup (gtk.patch)
- fixed crash with gtk 2.7 (bmo #300226, bnc #104586)
- fixed installation of the beagle plugin
- update industrial theme to 1.0.11 (#104564)
- included lockdownV2 (removed obsolete gconf.diff)
- linked firefox-bin with rpath to progdir
* Fri Aug  5 2005 stark@suse.de
- fixed profile locking (bmo #151188)
- install beagle extension globally
* Fri Jul 29 2005 stark@suse.de
- don't require and provide NSS libs (#98002)
- fixed printing error 'You cannot print while in print preview'
  (#96991, bmo #302445)
* Wed Jul 27 2005 stark@suse.de
- fixed Firefox on ppc (stack-direction.patch) (#97359)
- removed open-pref from startscript as it is done
  automatically now (#73042)
- updated Novell searchplugins
* Mon Jul 25 2005 stark@suse.de
- GTK filechooser is now modal (#8533)
- backed out patch to add tooltips to print-preview
  because it breaks localization
* Fri Jul 22 2005 stark@suse.de
- fixed another problem in printing patch
* Tue Jul 19 2005 stark@suse.de
- fixed error in ft-xft-ps2.patch
- disabled stripping in spec instead of patch
- added NSPR to PreReq
* Mon Jul 18 2005 stark@suse.de
- fixed some more regressions with final 1.0.6
- fixed width calculation in Postscript module (bmo #290292)
- fixed plugin event starvation (bnc #94749, #94751, bmo #301161)
* Fri Jul 15 2005 stark@suse.de
- searchplugins can now be installed per profile (#8176)
* Fri Jul 15 2005 stark@suse.de
- update to 1.0.6 which restores API compatibility
* Tue Jul 12 2005 stark@suse.de
- update to 1.0.5 final (#88509)
- don't strip explicitely
- don't ship beagle.xpi
* Wed Jul  6 2005 stark@suse.de
- update to 1.0.5-pre (20050705)
- use RPM_OPT_FLAGS for NSS component
- fixed implicit declarations and uninitialized used variables
- added patch for bmo #87969
* Tue Jul  5 2005 stark@suse.de
- fixed regression from security update (#95069, bmo #298478)
* Mon Jun 27 2005 stark@suse.de
- don't use system-prefs by default on NLD
- removed basic lockdown stuff for SUSE Linux
  (it's not needed and caused problems: bnc #75418)
- fixed NLD lockdown patch (bnc #75418)
- don't write prefs back to gconf for now
* Wed Jun 22 2005 stark@suse.de
- new NLD lockdown patch which is syncing user prefs to gconf
- update to 1.0.5pre security-release
* Thu Jun  9 2005 stark@suse.de
- new revision of NLD lockdown patch
- fixed remote usage behaviour in start script (bnc #41903)
- got more bugfixes from the branch
* Thu Jun  2 2005 stark@suse.de
- fixed neededforbuild
* Wed Jun  1 2005 stark@suse.de
- fixed IDN for 64bit platforms (bmo #236425, bnc #46268)
* Fri May 20 2005 stark@suse.de
- fixed keybinding for KP separator (bnc #84147)
- pulled security related patch from upstream branch
- update plastikfox theme to version 1.6
* Thu May 12 2005 stark@suse.de
- update to final 1.0.4 release
* Tue May 10 2005 stark@suse.de
- update to 1.0.4 security release
- removed s390(x) patches (upstream)
- made two more files %%verify (81692)
- updated NLD lockdown patch (81304)
* Thu Apr 28 2005 stark@suse.de
- use static NSPR libs from new location
* Sat Apr 23 2005 stark@suse.de
- activate usage of system NSPR for distributions after 9.3
- add patch to be able to use systen NSPR at all
* Fri Apr 22 2005 ro@suse.de
- use mozilla-gcc4.patch
* Thu Apr 21 2005 stark@suse.de
- don't execute gconf magic within build environment
* Sat Apr 16 2005 stark@suse.de
- update to final 1.0.3 release
* Thu Apr 14 2005 ro@suse.de
- fix problem in postinstall script
* Thu Apr 14 2005 stark@suse.de
- included fixed lockdown patch for NLD
- linked proxies within Firefox with gnome settings (NLD)
- added gconfd restart procedure to install script
  (only needed if gconf changes are done) (#76852)
* Sat Apr  2 2005 stark@suse.de
- update to security pre-release 1.0.3 (#75692)
  * Manual plug-in install, javascript vulnerability (bmo #288556)
  * Access memory vulnerability (bmo #288688)
* Fri Apr  1 2005 stark@suse.de
- added advanced lockdown features for ZLM integration (NLD-only)
* Tue Mar 22 2005 stark@suse.de
- update to final 1.0.2
- use new theme handling on NLD
- added default-plugin-less-annoying from mozilla
- use GTK2 for Flash
- use system NSPR on SUSE releases after 9.3
- made startscript PIS aware
- set g-application-name correctly (bmo #281979)
- added man-page
- use GTK system colors
- modify useragent string and add vendor id
- activate smooth-scrolling by default (#74310)
* Tue Mar 22 2005 stark@suse.de
- don't register beagle automatically (#74062)
- added default bookmarks for SUSE LINUX
* Mon Mar 21 2005 max@suse.de
- Fixed a typo in the shell code that handles inclusion of the
  Acrobat Reader plugin (#70861).
* Thu Mar 17 2005 stark@suse.de
- updates from upcoming 1.0.2
- added again logic to use Adobe Reader 7 (#70861)
- fixed crash in ICO decoding (#67142, bmo #245631)
- preinstall beagle extension (#72920)
- bugfixes in trigger scripts
- fixed industrial theming for Gnome (#72918)
* Sat Mar 12 2005 stark@suse.de
- fixed more security related bugs
  (bmo #284551, #284627, #285595)
* Wed Mar  9 2005 stark@suse.de
- update also GNOME desktop file (#71810)
- added firefox-gnome.png to filelist
- use correct Firefox icon
* Mon Mar  7 2005 stark@suse.de
- disable inclusion of acrobat plugin again (#70861)
- don't use gconfd in registration phase (#66381)
* Mon Mar  7 2005 adrian@suse.de
- use standard icon again for the default desktop file and
  add a Gnome-only desktop file for the Gnome icon
- add plastikfox chrome theme to fix button order within KDE
- add patch for automatic theme selection for KDE and Gnome
- do register extensions in rebuild-databases.sh instead of %%install,
  to fix needed timestamps
* Fri Mar  4 2005 stark@suse.de
- extend add-plugins to recognize Java 1.5 (#66909)
- changed comment in desktop-file (#66867)
* Tue Feb 22 2005 stark@suse.de
- make --display parameter working in all cases (bnc #66043)
- revised postscript patch
- final 1.0.1 codebase
* Mon Feb 21 2005 stark@suse.de
- added patch to create Postscript level 2 (instead of 3)
  (special thanks to Jungshik Shin)
- disabled freetype explicitly to be able to use the above patch
  (freetype wasn't used anymore since some time anyway)
* Fri Feb 18 2005 stark@suse.de
- got more patches from branch to get another IDN fix and to
  fix bug #51019
- enabled IDN again
* Wed Feb 16 2005 stark@suse.de
- bumped version number to 1.0.1
* Tue Feb 15 2005 stark@suse.de
- got updates from 1.0.1 branch
* Thu Feb 10 2005 stark@suse.de
- additional fireflashing fix (#50635, bmo #280664)
- some more security related fixes
  (bmo #268483, #273498, #277322)
- fire up GTK2 filepicker if GNOME is running
* Tue Feb  8 2005 stark@suse.de
- some prefs are ignored (bmo #261934)
- disabled default IDN (#50566)
- fixed some more bugzilla.mozilla.org bugs:
  [#276482], #280056, #280603
* Sun Feb  6 2005 stark@suse.de
- use same desktop categories for Professional and NLD
- added some lockdown stuff for printing and page saving
  (bmo #280488)
* Wed Feb  2 2005 stark@suse.de
- modified gconf.diff to honor ignore_hosts (bmo #280742)
- added a JS crasher fix (bmo #268535)
- added more fixes (bmo #255441, #273024, #275405, #275634)
* Fri Jan 28 2005 stark@suse.de
- added gplflash inclusion
- improved JRE inclusion
- reactivated usage of Acrobat Reader plugin
  (ready for acroread 7)
* Sat Jan 22 2005 stark@suse.de
- added some backported bugfixes
* Sat Dec 18 2004 stark@suse.de
- updated industrial theme to 1.0.9
- use slightly changed icon for menu-entry (bnc #275)
- use original desktop file for NLD again
* Thu Dec 16 2004 stark@suse.de
- newer patch for GNOME associations (bnc #362)
- fix overwriting of files with GTK picker (Ximian #65068)
- readded the industrial default theme patch for NLD
* Wed Dec 15 2004 stark@suse.de
- activate GTK filepicker for NLD again
- fix for GNOME helper applications with parameters
- make GNOME associations the default on NLD
* Sat Dec  4 2004 stark@suse.de
- fixed build on s390/s390x
- added patch to be able to install-global without running X
  (bmo #265859)
* Thu Nov 18 2004 stark@suse.de
- update industrial theme to 1.0.8 (still not activated)
- added patch to make home-directory the default download dir
  (on NLD is still used Desktop)
* Thu Nov 11 2004 stark@suse.de
- made initial window height smaller again
* Tue Nov  9 2004 stark@suse.de
- update to final 1.0 release (20041109)
* Thu Nov  4 2004 stark@suse.de
- update to 1.0rc2
* Sat Oct 30 2004 stark@suse.de
- added missing s390(x) patch
* Wed Oct 27 2004 stark@suse.de
- update to 1.0rc1 codebase
- printing via XFT/fontconfig
- freetype changes to avoid API conflicts with newer freetype2
- fixed build for s390/s390x
- removed AMD64 patch (included upstream)
- added translations sub-package
- removed "Show folder" patch for NLD (resolved upstream)
- don't use gnome-filepicker patch for NLD for now
- removed hppa buildfix (included upstream)
- removed untitled.patch (bmo #24068) resolved by (bmo #262478)
- use make -C browser/installer now to prepare installation
- don't check for default browser at startup (#47587)
- updated industrial.jar (0.99.13) (disabled)
* Fri Oct 15 2004 stark@suse.de
- inherit locale from system
- fixed chrome registration
* Wed Oct  6 2004 joeshaw@suse.de
- disable gconf settings as default (Ximian #67718)
* Wed Oct  6 2004 stark@suse.de
- fixed inclusion of RealPlayer plugin again
* Tue Oct  5 2004 stark@suse.de
- small important fix in firefox-download.patch (Ximian #65472)
* Sat Oct  2 2004 stark@suse.de
- added security-fix from 0.10.1 (mozilla.org #259708) (#46687)
* Fri Oct  1 2004 stark@suse.de
- final fix for downloading to Desktop folder (Ximian #65756)
- remove Postscript from printer names (Ximian #65560)
* Thu Sep 30 2004 shprasad@suse.de
- Modified the MozillaFirefox.desktop file.
  Changed the name 'Firefox' to 'Firefox Web Browser'.
  Also changed it for all languages.
* Wed Sep 29 2004 stark@suse.de
- fix inclusion of RealPlayer plugin (Ximian #65711)
* Mon Sep 27 2004 joeshaw@suse.de
- Update the industrial default patch, for some reason it didn't
  take before.
* Fri Sep 24 2004 stark@suse.de
- fix for Ximian #65176 (mozilla.org #240068)
- revised patch for update function (Ximian #65615)
* Thu Sep 23 2004 joeshaw@suse.de
- Uncomment the patch which tells the UI that industrial is the
  default.
* Thu Sep 23 2004 stark@suse.de
- open Nautilus on NLD for 'Show folder' in download settings
  (Ximian #65472) by sragavan@novell.com
- save to Desktop folder if selected (Ximian #65756)
  by sragavan@novell.com
* Wed Sep 22 2004 stark@suse.de
- synced NLD package with 9.2 version
- GTK2 filepicker does now ask for confirmation when overwriting
  files (Ximian #65068) by sagarwala@novell.com
- no direct update function (Ximian #65615) by rganesan@novell.com
- throbber linked to Novell (Ximian #66283) by rganesan@novell.com
- make industrial the default theme for NLD
  (Ximian #65542) by joeshaw@suse.de
* Mon Sep 20 2004 joeshaw@suse.de
- Add default bookmarks.  Ximian #65546.
- Add the industrial theme, but it's not the default yet.
- Remove acroread from add-plugins because it's badly behaved.
  Ximian #65499.
* Mon Sep 20 2004 federico@ximian.com
- Added MozillaFirefox-toplevel-window-height.diff for
  http://bugzilla.ximian.com/show_bug.cgi?id=65543
* Sun Sep 19 2004 stark@suse.de
- use GNOME system prefs only for NLD by default
  (fixes bug #45575)
* Fri Sep 17 2004 stark@suse.de
- joeshaw@suse.de: Update GConf patch so that proxy settings work
  correctly (Ximian #64461)
- don't search Java on every path (Ximian #65383)
- added some missing fixes for official release
- added new java package name for triggers (#45257)
* Sat Sep 11 2004 stark@suse.de
- update to official 1.0PR (0.10)
- adopted gnome-filepicker patch
- removed obsolete CUPS hack from start-script
  (Ximian #65635, #65560)
* Thu Sep  9 2004 stark@suse.de
- fixed endianess on AMD64 in JS component (#34743)
* Mon Sep  6 2004 stark@suse.de
- fixed filelist
* Mon Sep  6 2004 stark@suse.de
- update to 1.0PR (aka 0.10)
* Fri Sep  3 2004 stark@suse.de
- added ppc64 patch
* Thu Sep  2 2004 dave@suse.de
- Fixed up the .desktop installation on nld
* Wed Sep  1 2004 shprasad@suse.de
- Doesn't ask to set Firefox as default web-browser.
* Tue Aug 31 2004 stark@suse.de
- next new version for filepicker stuff
- deactivated native filepicker for NLD
- update to snapshot (20040831)
* Tue Aug 24 2004 stark@suse.de
- new version of gnome-filepicker patch
- added patch for config
* Fri Aug 20 2004 stark@suse.de
- update to snapshot (20040820)
* Thu Aug 19 2004 stark@suse.de
- added workaround for mozilla bug #246313
  (Firefox does not start: getting "cannot open display" error)
* Wed Aug 18 2004 stark@suse.de
- added some patches from Ximian
  - use GNOME filepicker
  - use more gconf settings
  - set startup homepage to Novell
* Tue Aug 17 2004 stark@suse.de
- update to pre-1.0.0 (20040817)
* Thu Aug  5 2004 stark@suse.de
- security update to 0.9.3
  (including #43312 and others)
- handle RealPlayer 9 plugin
* Mon Aug  2 2004 ro@suse.de
- recode desktop file to utf-8
* Wed Jul 28 2004 stark@suse.de
- added fix against certificate spoofing (#43312)
* Fri Jul 23 2004 stark@suse.de
- update to 0.9.2
- added workaround for extension registry
- removed old (incompatible) mozex extension
* Tue Jun 29 2004 stark@suse.de
- update to 0.9.1
- added hint to run as root first
* Tue Jun 15 2004 stark@suse.de
- update to 0.9
- added patch for newer freetype
* Fri Apr  2 2004 stark@suse.de
- removing relocation of TEMP directory (#34391)
* Mon Mar 29 2004 stark@suse.de
- update to 0.8.0+ (20040503)
- removed firefox logos and activate official branding for
  milestone builds
- changed profile-dir to .firefox
- added some needed files
- enabled gnomevfs extension
* Fri Mar 26 2004 uli@suse.de
- fixed hang during build on s390* (bug #35440)
* Wed Mar  3 2004 stark@suse.de
- removed unused patches for GTK2 build
- more fixes for (#35179)
* Mon Mar  1 2004 stark@suse.de
- improved start-script to interact with thunderbird (#35179)
* Thu Feb 26 2004 stark@suse.de
- use official releasedate
- added official (trademarked) artwork
- added firefox icon to /usr/share/pixmaps
- cleaned up spec-file (there will be no GTK1 version)
* Tue Feb 24 2004 stark@suse.de
- fixed optimization for non-x86 archs
* Tue Feb 24 2004 stark@suse.de
- adopted file-list and build options to original distribution
- added prdtoa fix (#32963)
- added hook for static firefox build to rebuild-databases.sh
- added compiler flags for security/ (nss-opt.patch)
- included mozex (mozex.mozdev.org)
- added -Os as optimization flag
* Mon Feb  9 2004 stark@suse.de
- renamed to MozillaFirefox
- update to final version 0.8
* Fri Feb  6 2004 stark@suse.de
- update to Firebird 0.8 (20040205)
- added mips build fix
- set PS printer list in MozillaFirebird.sh
- use lib64 again for biarch platforms
* Sat Jan 10 2004 adrian@suse.de
- build as user
* Fri Aug 22 2003 stark@suse.de
- upstream sync for 0.6.1post
* Sun Aug 10 2003 stark@suse.de
- removed dmoz from searchplugins-filelist
* Fri Aug  8 2003 stark@suse.de
- update to 0.6.1post (TRUNK)
- use -fno-strict-aliasing
* Thu Jul 31 2003 stark@suse.de
- update to 0.6.1 (MOZILLA_1_4_BRANCH)
- synchronized with mozilla-source
- created file-list
* Thu Jul 10 2003 stark@suse.de
- update to snapshot 20030709
- fixed generation of symlink MozillaFirebird-xremote-client
* Fri Jun 20 2003 stark@suse.de
- update to snapshot 20030622 (0.7pre)
* Mon May 19 2003 stark@suse.de
- update to snapshot 20030518 (0.6)
* Wed May  7 2003 stark@suse.de
- update to snapshot 20030507
* Wed Apr 30 2003 stark@suse.de
- initial SuSE package
